% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_processing.R
\name{convergence.dalmatian}
\alias{convergence.dalmatian}
\title{Convergence}
\usage{
\method{convergence}{dalmatian}(
  object,
  pars = NULL,
  nstart = start(object$coda),
  nend = end(object$coda),
  nthin = coda::thin(object$coda),
  raftery = NULL,
  ...
)
}
\arguments{
\item{object}{Object of class \code{dalmatian} created by \code{dalmatian()}.}

\item{pars}{List of parameters to assess. If NULL (default) then diagnostics are computed for the fixed effects and random effects standard deviations in the mean, dispersion, and joint components.}

\item{nstart}{Start point for computing summary statistics (relative to true start of chain).}

\item{nend}{End point for computing summary statistics (relative to true start of chain).}

\item{nthin}{Thinning factor for computing summary statsitics (relative to full chain and not previously thinned output).}

\item{raftery}{List of arguments to be passed to \code{raftery.diag()}. Any values not provided will be set to their defaults (see \code{help(raftery.diag())} for details).}

\item{...}{Ignored}
}
\value{
List containing Gelman-Rubin and Raftery convergence diagnostics and effective sampel sizes for the selected parameters.
}
\description{
Compute convergence diagnostics for a dalmatian object.
}
