% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{msParframe}
\alias{msParframe}
\title{Reproducibly construct "random" parframes}
\usage{
msParframe(pars, n = 20, seed = 12345, samplefun = stats::rnorm, ...)
}
\arguments{
\item{pars}{Named vector. If \code{samplefun} has a "mean"-argument, values of pars will used as mean}

\item{n}{Integer how many lines should the parframe have}

\item{seed}{Seed for the random number generator}

\item{samplefun}{random number generator: \code{\link{rnorm}}, \code{\link{runif}}, etc...}

\item{...}{arguments going to samplefun}
}
\value{
parframe (without metanames)
}
\description{
The output of this function can be used for the \code{center} - argument of \code{\link{mstrust}}
}
\examples{
msParframe(c(a = 0, b = 100000), 5)

# Parameter specific sigma
msParframe(c(a = 0, b = 100000), 5, samplefun = rnorm, sd = c(100, 0.5))
}
\seealso{
\code{\link{mstrust}} and \code{\link{parframe}}
}
