% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenodo.R
\docType{data}
\name{zenodo_get_tarball}
\alias{zenodo_get_tarball}
\alias{gparlsample_url_restricted}
\title{Download corpus tarball from Zenodo}
\format{
An object of class \code{character} of length 1.
}
\usage{
zenodo_get_tarball(
  url,
  destfile = tempfile(fileext = ".tar.gz"),
  checksum = TRUE,
  verbose = TRUE,
  progress = TRUE
)

gparlsample_url_restricted
}
\arguments{
\item{url}{Landing page at Zenodo for resource. Can also be the URL for
restricted access (?token= appended with a long key).}

\item{destfile}{A \code{character} vector with the file path where the downloaded
file is to be saved. Tilde-expansion is performed. Defaults to a temporary
file.}

\item{checksum}{A \code{logical} value, whether to check md5 sum.}

\item{verbose}{A \code{logical} value, whether to output progess messages.}

\item{progress}{A \code{logical} value, whether to report progress during
download.}
}
\value{
The filename of the downloaded corpus tarball, designed to serve as
input for \code{\link{corpus_install}} (as argument \code{tarball}).
}
\description{
Download corpus tarball from Zenodo. Downloading both freely available data
and data with restricted access is supported.
}
\details{
A sample subset of the GermaParl corpus is deposited at Zenodo for
testing purposes. There are identical open access and restricted versions
of GermaParlSample to test different flavours of downloading a resource
from Zenodo. The URL for restricted access includes an access token which
is very lengthy. This URL is included as a dataset in the package to avoid
excessive line in sample code. Note that URLs that give access to
restricted data are usually not to be shared.
}
\examples{
\donttest{
# Temporary directory structure as a preparatory step
Sys.setenv(CORPUS_REGISTRY = "")
cwb_dirs <- create_cwb_directories(
  prefix = tempdir(),
  ask = FALSE,
  verbose = FALSE
)
Sys.setenv(CORPUS_REGISTRY = cwb_dirs[["registry_dir"]])

# Download and install open access resource
gparl_url_pub <- "https://doi.org/10.5281/zenodo.3823245"
tarball_tmp <- zenodo_get_tarball(url = gparl_url_pub)
corpus_install(tarball = tarball_tmp)

# Download and install resource with restricted access
tarball_tmp <- zenodo_get_tarball(url = gparlsample_url_restricted)
corpus_install(tarball = tarball_tmp)
}
}
\keyword{datasets}
