% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_data}
\alias{cvd_indicator_data}
\title{Indicator data}
\usage{
cvd_indicator_data(indicator_id = 1, time_period_id = 1, area_id = 1)
}
\arguments{
\item{indicator_id}{integer - indicator for which to return data (compulsory)}

\item{time_period_id}{integer - time period for which to return data for (compulsory)}

\item{area_id}{integer - area for which to return data for (compulsory)}
}
\value{
Tibble of details for the indicator in the area and a national comparison
}
\description{
Returns all metric data for a specified indicator. Data will include values
for both selected area, and organisation at National Level (usually England).
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2F\%3Cindicator_id\%3E\%2Fdata}{Indicator data}
}
\examples{
# Look at 'AF: treatment with anticoagulants' (indicator ID 7) in time
# period 17 for  'Leicester Central PCN' (area_id 701) focussed on metrics
# by gender:
cvd_indicator_data(time_period_id = 17, indicator_id = 7, area_id = 701) |>
  dplyr::filter(MetricCategoryTypeName == 'Sex') |>
  dplyr::select(MetricID, MetricCategoryName, AreaData.AreaName,
  AreaData.Value, NationalData.AreaName, NationalData.Value)
}
\seealso{
\code{\link[=cvd_indicator_list]{cvd_indicator_list()}}, \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}}, \code{\link[=cvd_indicator]{cvd_indicator()}},
\code{\link[=cvd_indicator_tags]{cvd_indicator_tags()}}, \code{\link[=cvd_indicator_details]{cvd_indicator_details()}}, \code{\link[=cvd_indicator_sibling]{cvd_indicator_sibling()}},
\code{\link[=cvd_indicator_child_data]{cvd_indicator_child_data()}}, \code{\link[=cvd_indicator_metric_data]{cvd_indicator_metric_data()}},
\code{\link[=cvd_indicator_raw_data]{cvd_indicator_raw_data()}}, \code{\link[=cvd_indicator_nationalarea_metric_data]{cvd_indicator_nationalarea_metric_data()}},
\code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}}, \code{\link[=cvd_indicator_pathway_group]{cvd_indicator_pathway_group()}}, #
\code{\link[=cvd_indicator_group]{cvd_indicator_group()}}, \code{\link[=cvd_indicator_metric_timeseries]{cvd_indicator_metric_timeseries()}},
\code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}}, \code{\link[=cvd_indicator_metric_systemlevel_comparison]{cvd_indicator_metric_systemlevel_comparison()}},
\code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}}
}
