% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_area_nested_subsystems}
\alias{cvd_area_nested_subsystems}
\title{Area nested sub systems}
\usage{
cvd_area_nested_subsystems(area_id = 5)
}
\arguments{
\item{area_id}{integer - the area to return data for (compulsory)}
}
\value{
List of named tibbles containing details for the area and each sub-level areas
}
\description{
Returns given area and children areas in a nested structure
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Farea\%2F\%3Carea_id\%3E\%2FnestedSubSystems}{Area nested subsystems}
}
\examples{
# View details for for Somerset STP
returned_list <- cvd_area_nested_subsystems(area_id = 5)
returned_list |> summary()

# see details for five of the immediate children of Somerset STP
returned_list$level_2 |>
  dplyr::slice_head(n = 5)

# View details for Leicester Central PCN
returned_list <- cvd_area_nested_subsystems(area_id = 701)
returned_list |> summary()

# see details for the GP practice children of the PCN
returned_list$level_2
}
\seealso{
\code{\link[=cvd_area_list]{cvd_area_list()}}, \code{\link[=cvd_area_details]{cvd_area_details()}}, \code{\link[=cvd_area_unassigned]{cvd_area_unassigned()}}, \code{\link[=cvd_area_search]{cvd_area_search()}}, \code{\link[=cvd_area_flat_subsystems]{cvd_area_flat_subsystems()}}
}
