% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-ScenarioSequence.R
\name{sequence}
\alias{sequence}
\alias{ScenarioSequence-class}
\title{Sequence of scenarios}
\value{
an S4 object of type \linkS4class{ScenarioSequence}
}
\description{
A sequence of scenarios is treated as a single scenario and each scenario
is simulated one after the other. If scenario \code{n} in a sequence was simulated,
scenario \code{n+1} will start off in the model state where \code{n} had ended.
Scenario sequences can be used to e.g. implement changes in model parameters
over time.
}
\details{
\subsection{Requirements}{

All scenarios in a sequence must fulfill the following requirements:
\itemize{
\item All scenarios must have identical state variables
\item The \emph{output times} of all scenarios must represent a continuous time series
without gaps or overlaps
}
}

\subsection{Limitations}{

Only simulation of sequences are supported, at the moment.
Effects and effect profiles (EPx values) cannot be derived, yet.
}
}
\examples{
# create two scenarios that need to be simulated one after the other
scen1 <- minnow_it \%>\% set_times(0:3)
scen2 <- minnow_it \%>\% set_times(3:6) \%>\% set_param(c(kd=0))

# create a sequence and assign scenarios
sq <- sequence(list(scen1, scen2))

# simulate the sequence

simulate(sq)

}
