% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{getHypers}
\alias{getHypers}
\title{Hyperparameter Retrieval Function}
\usage{
getHypers(dat, summ_stat, new_df = FALSE)
}
\arguments{
\item{dat}{A \code{data.frame} of estimators and their hyperparameter values.
Specifically, this is one of the outputs of \code{summary.cvCovEst()} or
\code{cvCovEst()}.}

\item{summ_stat}{A character vector specifying the summary statistic of
interest.}

\item{new_df}{A \code{logical} indicating whether a new \code{data.frame}
should be returned with columns for individual hyperparameters.  Default is
\code{FALSE}.}
}
\value{
A named \code{list} containing the names of all hyperparameters and
their associated values, or a new wider \code{data.frame}.
}
\description{
\code{getHypers()} retrieves the names and values of all
hyperparameters associated with an estimator passed to \code{cvCovEst()}.
}
\keyword{internal}
