% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ComputeSMLE}
\alias{ComputeSMLE}
\title{Smoothed Maximum Likelihood Estimator}
\usage{
ComputeSMLE(data, x, bw)
}
\arguments{
\item{data}{Dataframe with three variables:
\describe{
    \item{t}{Observation points t sorted in ascending order. All observations need to be positive. The total number of unique observation points equals \code{length(t)}.}
    \item{freq1}{Frequency of observation t satisfying \eqn{x \le t}.
                  The total number of observations with censoring indicator \eqn{\delta =1} equals \code{sum(freq1)}. }
    \item{freq2}{Frequency of observation t. The sample size equals \code{sum(freq2)}. If no tied observations are present in the data \code{length(t)} equals \code{sum(freq2)}. }
}}

\item{x}{numeric vector containing the points where the confidence intervals are computed.}

\item{bw}{numeric vector of size \code{length(x)}. This vector contains the pointwise bandwidth values for each point in the vector x.}
}
\value{
SMLE(x) Smoothed Maximum Likelihood Estimator. This is a vector of size \code{length(x)} containing the values of the SMLE for each point in the vector x.
}
\description{
The function ComputeSMLE computes the Smoothed Maximum Likelihood Estimator of the distribution function under current status data.
}
\details{
In the current status model, the variable of interest \eqn{X} with distribution function \eqn{F} is not observed directly.
A censoring variable \eqn{T} is observed instead together with the indicator \eqn{\Delta = (X \le T)}.
ComputeSMLE computes the SMLE of \eqn{F} based on a sample of size \code{n <- sum(data$freq2)}.
The bandwidth parameter vector that minimizes the pointwise Mean Squared Error using the subsampling principle in combination with undersmoothing is returned by the function \link{ComputeBW}.
}
\examples{
library(Rcpp)
library(curstatCI)

# sample size
n <- 1000

# Uniform data  U(0,2)
set.seed(2)
y <- runif(n,0,2)
t <- runif(n,0,2)
delta <- as.numeric(y <= t)

A<-cbind(t[order(t)], delta[order(t)], rep(1,n))
grid <-seq(0,2 ,by = 0.01)

# bandwidth vector
h<-rep(2*n^-0.2,length(grid))

smle <-ComputeSMLE(A,grid,h)
plot(grid, smle,type ='l', ylim=c(0,1), main= "",ylab="",xlab="",las=1)


}
\references{
Groeneboom, P. and Hendrickx, K. (2017). The nonparametric bootstrap for the current status model. \url{https://arxiv.org/abs/1701.07359}
}
\seealso{
\code{\link{ComputeConfIntervals}}
}
