% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.predCuresurv.R
\name{plot.predCuresurv}
\alias{plot.predCuresurv}
\title{plot method for curesurv prediction objects}
\usage{
\method{plot}{predCuresurv}(
  x,
  fun = "all",
  conf.int = FALSE,
  conf.type = c("log", "log-log", "plain"),
  legend.out = TRUE,
  xlab = "Time since diagnosis",
  ylab.haz = "excess hazard",
  ylab.surv = "net survival",
  ylab.ptcure = "P(t)",
  ylab.cumhaz = "cumulative excess hazard",
  ylab.logcumhaz = "logarithm of cumulative excess hazard",
  col.haz = "black",
  col.surv = "black",
  col.ptcure = "black",
  col.cumhaz = "black",
  col.logcumhaz = "black",
  col.tau = "red",
  col.ttc = "green4",
  col.p95 = "black",
  col.pi = "blue",
  lty.surv = 1,
  lty.haz = 1,
  lty.ptcure = 1,
  lty.cumhaz = 1,
  lty.logcumhaz = 1,
  lty.pi = 2,
  lty.tau = 2,
  lty.ttc = 3,
  lty.p95 = 4,
  lty.ic = 5,
  lwd.main = 1,
  lwd.sub = 1,
  lwd.ic = 1,
  ...
)
}
\arguments{
\item{x}{result of the \code{predCuresurv} function}

\item{fun}{in "haz" or "surv" or "pt_cure", "cumhaz", "logcumhaz", the plot
produced is that of (excess) hazard, or that of (net) survival, or that of
the probability P(t) of being cured at a given time t after diagnosis
knowing that he/she was alive up to time t is provided, or that of
cumulative hazard or that of the logarithm of the cumulative hazard; if
\code{fun = "all"}, the plots of the three first indicators are produced.}

\item{conf.int}{an argument expected to be TRUE if the confidence intervals of the
related-indicator specified by the argument "fun" are needed. The default
option is FALSE. Confidence intervals are not available for \code{fun="cumhaz"} and \code{fun="logcumhaz"}}

\item{conf.type}{One of "plain", "log", "log-log".
The first option causes the standard intervals curve +- k *se(curve),
where k is determined from conf.int. The log option calculates intervals
based on log(curve). The log-log option bases
the intervals on the log(-log(curve)).}

\item{legend.out}{an argument deciding the place of the legend if \code{fun="all"}.
The default value is TRUE and forces most of the legend on the empty bottom-right plot slot.
If value is FALSE, the legend will be printed entirely in each subplot.}

\item{xlab}{label for the x-axis of the plot.}

\item{ylab.haz}{optional label for the y-axis of the plot of excess hazard}

\item{ylab.surv}{optional label for the y-axis of the plot of net survival}

\item{ylab.ptcure}{optional label for the y-axis of the plot of the probability
\code{P(t)} of being cured at a given time t after diagnosis knowing that
he/she was alive up to time t}

\item{ylab.cumhaz}{optional label for the y-axis of the plot of cumulative excess hazard}

\item{ylab.logcumhaz}{optional label for the y-axis of the plot of logarithm of cumulative excess hazard}

\item{col.haz}{optional argument to specify the color of curve of the excess hazard}

\item{col.surv}{optional argument to specify the color of curve of the net survival}

\item{col.ptcure}{optional argument to specify the color of curve of probability
\code{P(t)} of being cured at a given time t after diagnosis knowing that
he/she was alive up to time \code{t}.}

\item{col.cumhaz}{optional argument to specify the color of curve of cumulative excess hazard}

\item{col.logcumhaz}{optional argument to specify the color of curve of the logarithm of cumulative excess hazard}

\item{col.tau}{optional argument to specify the color of curve of time-to-null excess hazard}

\item{col.ttc}{optional argument to specify the color of curve of time-to-cure}

\item{col.p95}{optional argument to specify the color for the line highlighting \eqn{\epsilon} when \eqn{P(t) \ge 1-\epsilon}}

\item{col.pi}{optional argument to specify the color of cure proportion}

\item{lty.surv}{stands for line types for net survival}

\item{lty.haz}{stands for line types for excess hazard}

\item{lty.ptcure}{stands for line types for probability P(t) of being cured
at a given time t after diagnosis knowing that he/she was alive up to time t.}

\item{lty.cumhaz}{stands for line types for cumulative excess hazard}

\item{lty.logcumhaz}{stands for line types for logarithm cumulative excess hazard}

\item{lty.pi}{stands for line types for cure proportion}

\item{lty.tau}{stands for line types for time-to-null excess hazard}

\item{lty.ttc}{stands for line types for time-to-cure}

\item{lty.p95}{stands for line types for the line highlighting \eqn{\epsilon} when \eqn{P(t) \ge 1-\epsilon}}

\item{lty.ic}{stands for line types for confidence intervals}

\item{lwd.main}{line width for the main line (haz, surv, pt_cure, cumhaz, logcumhaz)}

\item{lwd.sub}{line width for the additionnal lines (ttc, p95, tau...)}

\item{lwd.ic}{line width for the confidence intervals lines}

\item{...}{additional options as in the classical plot method.}

\item{ylab}{optional label for the y-axis of the plot. Depending to the curve
of interest (hazard, survival, probability of being cured at a given time t,
or all),the argument must be named \code{ylab.haz, ylab.surv, ylab.ptcure}.
If missing some default labels are provided depending on the curve of
interest. This name can be found in the data.frame from the result of
the \code{predict.curesurv} function.}
}
\value{
No value is returned.
}
\description{
Produces figures of (excess) hazard, (net) survival and
probability P(t) of being cured at a given time t after diagnosis knowing
that he/she was alive up to time t.
}
\examples{

\donttest{

library("curesurv")
library("survival")

 testiscancer$age_crmin <- (testiscancer$age- min(testiscancer$age)) /
              sd(testiscancer$age)

fit_m1_ad_tneh <- curesurv(Surv(time_obs, event) ~ z_tau(age_crmin) +
                          z_alpha(age_crmin),
                          pophaz = "ehazard",
                          cumpophaz = "cumehazard",
                          model = "nmixture", dist = "tneh",
                          link_tau = "linear",
                          data = testiscancer,
                          method_opt = "L-BFGS-B")

 fit_m1_ad_tneh


#'  #mean of age
 newdata1 <- with(testiscancer,
 expand.grid(event = 0, age_crmin = mean(age_crmin), time_obs  = seq(0.001,10,0.1)))

 pred_agemean <- predict(object = fit_m1_ad_tneh, newdata = newdata1)


 #max of age
 newdata2 <- with(testiscancer,
 expand.grid(event = 0,
 age_crmin = max(age_crmin),
  time_obs  = seq(0.001,10,0.1)))

 pred_agemax <- predict(object = fit_m1_ad_tneh, newdata = newdata2)

   # predictions at time 2 years and  of age

   newdata3 <- with(testiscancer,
      expand.grid(event = 0,
      age_crmin = seq(min(testiscancer$age_crmin),max(testiscancer$age_crmin), 0.1),
      time_obs  = 2))

   pred_age_val <- predict(object = fit_m1_ad_tneh, newdata = newdata3)

 #plot of 3 indicators for mean age

 plot(pred_agemean, fun="all")


 #plot of net survival for mean and maximum age (comparison)

oldpar <- par(no.readonly = TRUE)

par(mfrow = c(2, 2),
    cex = 1.0)
plot(pred_agemax$time,
    pred_agemax$ex_haz,
    type = "l",
    lty = 1,
    lwd = 2,
    xlab = "Time since diagnosis",
    ylab = "excess hazard")
lines(pred_agemean$time,
     pred_agemean$ex_haz,
     type = "l",
     lty = 2,
     lwd = 2)

legend("topright",
      horiz = FALSE,
      legend = c("hE(t) age.max = 79.9", "hE(t) age.mean = 50.8"),
      col = c("black", "black"),
      lty = c(1, 2, 1, 1, 2, 2))
grid()

plot(pred_agemax$time,
    pred_agemax$netsurv,
    type = "l",
    lty = 1,
    lwd = 2,
    ylim = c(0, 1),
    xlab = "Time since diagnosis",
    ylab = "net survival")
lines(pred_agemean$time,
     pred_agemean$netsurv,
     type = "l",
     lty = 2,
     lwd = 2)
legend("bottomleft",
       horiz = FALSE,
       legend = c("Sn(t) age.max = 79.9", "Sn(t) age.mean = 50.8"),
       col = c("black", "black"),
      lty = c(1, 2, 1, 1, 2, 2))
grid()

plot(pred_agemax$time,
    pred_agemax$pt_cure,
    type = "l",
    lty = 1,
    lwd = 2,
    ylim = c(0, 1), xlim = c(0,30),
    xlab = "Time since diagnosis",
    ylab = "probability of being cured P(t)")

lines(pred_agemean$time,
     pred_agemean$pt_cure,
     type = "l",
     lty = 2,
     lwd = 2)


abline(v = pred_agemean$tau[1],
      lty = 2,
      lwd = 2,
      col = "blue")
abline(v = pred_agemean$TTC[1],
       lty = 2,
       lwd = 2,
       col = "red")
abline(v = pred_agemax$tau[1],
       lty = 1,
       lwd = 2,
       col = "blue")
abline(v = pred_agemax$TTC[1],
       lty = 1,
       lwd = 2,
      col = "red")
grid()

legend("bottomright",
       horiz = FALSE,
       legend = c("P(t) age.max = 79.9",
                 "P(t) age.mean = 50.8",
                 "TNEH age.max = 79.9",
                 "TTC age.max = 79.9",
                 "TNEH age.mean = 50.8",
                 "TTC age.mean = 50.8"),
      col = c("black", "black", "blue", "red", "blue", "red"),
      lty = c(1, 2, 1, 1, 2, 2))


 val_age <- seq(min(testiscancer$age_crmin),
                max(testiscancer$age_crmin), 0.1) * sd(testiscancer$age) +
                min(testiscancer$age)


 pred_age_val <- predict(object = fit_m1_ad_tneh, newdata = newdata3)


par(mfrow=c(2,2))
 plot(val_age,
     pred_age_val$ex_haz, type = "l",
     lty=1, lwd=2,
     xlab = "age",
     ylab = "excess hazard")
grid()

 plot(val_age,
     pred_age_val$netsurv, type = "l", lty=1,
     lwd=2, xlab = "age", ylab = "net survival")
     grid()

 plot(val_age,
     pred_age_val$pt_cure, type = "l", lty=1, lwd=2,
     xlab = "age",
     ylab = "P(t)")
     grid()
par(oldpar)
 }

}
\seealso{
\code{\link[=predict.curesurv]{predict.curesurv()}}, \code{\link[=print.curesurv]{print.curesurv()}}, \code{\link[=curesurv]{curesurv()}}, \code{browseVignettes("curesurv")}
}
\author{
Juste Goungounga, Judith Breaud, Eugenie Blandin, Olayide Boussari, Valerie Jooste
}
\keyword{plot.curesurv}
