% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-int.R
\name{read_uint8}
\alias{read_uint8}
\alias{read_int8}
\alias{read_int16}
\alias{read_uint16}
\alias{read_int32}
\alias{read_uint32}
\alias{read_int64}
\alias{read_uint64}
\title{Read integer data from a connection}
\usage{
read_uint8(con, n = 1, endian = NULL)

read_int8(con, n = 1, endian = NULL)

read_int16(con, n = 1, endian = NULL)

read_uint16(con, n = 1, endian = NULL)

read_int32(con, n = 1, endian = NULL)

read_uint32(con, n = 1, endian = NULL, promote = NULL)

read_int64(con, n = 1, endian = NULL, promote = NULL, bounds_check = NULL)

read_uint64(con, n = 1, endian = NULL, promote = NULL, bounds_check = NULL)
}
\arguments{
\item{con}{Connection object or raw vector. Connection objects can be 
created with \code{file()}, \code{url()}, 
\code{rawConnection()} or any of the other many connection creation
functions.}

\item{n}{Number of elements to read. Default: 1}

\item{endian}{Ordering of bytes within the file when reading multi-byte values.
Possible values: 'big' or 'little'.  
Default: NULL indicates that
endian option should be retrieved from the connection object if possible
(where the user has used \code{\link{set_endian}()}) or otherwise 
will be set to \code{"little"}}

\item{promote}{For 'uin32', 'int64' and 'uint64' types, the range of possible
values exceeds R's standard integer type.  For these integer types, 
values will be promoted to a different container type.
Possible options 'dbl', 'raw', 'hex' and 'bit64'.
Default: NULL indicates that
this option should be retrieved from the connection object if possible
(where the user has used \code{\link{set_integer_promotion}()}) or otherwise 
will default to \code{"dbl"}.
\describe{
  \item{\code{dbl}}{Read integer values as double precision floating point. A 'double' will
        hold integer values (without loss) from -(2^53) up to (2^53).  A 
        further warning will be issued if an attempt is made to store 
        an integer value that lies outside this range}
  \item{\code{hex}}{Read integers as character vector of hexadecimal strings}
  \item{\code{raw}}{Read integer value as a sequence of raw bytes}
  \item{\code{bit64}}{Read integer value as a vector of 
        type \code{bit64::integer64}. This is valid only when reading
        'int64' and 'uint64' types}
}}

\item{bounds_check}{Check values lie within bounds of the given type.
Default: NULL indicates that
this option should be retrieved from the connection object if possible
(where the user has used \code{\link{set_bounds_check}()}) or otherwise 
will be set to \code{"error"}}
}
\value{
Integer data. Usually in standard R integer vector but depending on 
        the \code{promote} option may be returned in alternate formats
}
\description{
Read integer values into a standard R vector of integers or alternate
containers for large types
}
\details{
\describe{
  \item{8-bit integers}{\code{read_int8()} and \code{read_uint8()}}
  \item{16-bit integers}{\code{read_int16()} and \code{read_uint16()}}
  \item{32-bit integers}{\code{read_int32()} and \code{read_uint32()}}
  \item{64-bit integers}{\code{read_int64()} and \code{read_uint64()}}
}
}
\examples{
# Raw vector with 16 bytes (128 bits) of dummy data
data <- as.raw(c(1:7, 0, 1:8))
con <- rawConnection(data, 'rb')
read_int64(con, n = 1)
read_uint8(con, n = 4)
close(con)

}
\seealso{
Other data input functions: 
\code{\link{read_f64}()},
\code{\link{read_hex}()},
\code{\link{read_raw}()},
\code{\link{read_str}()},
\code{\link{scan_dbl}()}
}
\concept{data input functions}
