% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ph.R
\encoding{UTF-8}
\name{plot_ph}
\alias{plot_ph}
\title{Constructs the pattern histogram associated with a given category of a
categorical time series}
\usage{
plot_ph(
  series,
  category,
  plot = TRUE,
  title = paste0("Pattern histogram (", category, ")"),
  ...
)
}
\arguments{
\item{series}{An object of type \code{tsibble} (see R package \code{tsibble}), whose column named Values
contains the values of the corresponding CTS. This column must be of class \code{factor} and its levels
must be determined by the range of the CTS.}

\item{category}{The selected category.}

\item{plot}{Logical. If \code{plot = TRUE} (default), returns the pattern
histogram. Otherwise, returns the frequencies of cycle lengths associated
with the corresponding category.}

\item{title}{The title of the graph.}

\item{...}{Additional parameters for the function.}
}
\value{
The pattern histogram.
}
\description{
\code{plot_ph} constructs the pattern histogram associated with a given category of a
categorical time series.
}
\details{
Constructs the pattern histogram for a specific category of a CTS. This graph
represents the frequencies of the cycles for the corresponding category according
to their length.
}
\examples{
sequence_1 <- GeneticSequences[which(GeneticSequences$Series==1),]
ph <- plot_ph(sequence_1,
category = 'a') # Constructing the pattern histogram
# for the first CTS in dataset GeneticSequences concerning the category 'a'
cycle_lengths <- plot_ph(sequence_1,
category = 'a', plot = FALSE) # Obtaining the frequencies of cycle lengths
}
\references{
{

  \insertRef{weiss2008visual}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
