% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanoptimis.R
\name{stanoptimis}
\alias{stanoptimis}
\title{Optimize / importance sample a stan or ctStan model.}
\usage{
stanoptimis(
  standata,
  sm,
  init = "random",
  initsd = 0.01,
  estonly = FALSE,
  tol = 1e-08,
  stochastic = TRUE,
  priors = TRUE,
  carefulfit = TRUE,
  bootstrapUncertainty = FALSE,
  subsamplesize = 1,
  parsteps = c(),
  parstepsAutoModel = FALSE,
  groupFreeThreshold = 0.5,
  plot = FALSE,
  is = FALSE,
  isitersize = 1000,
  isESS = 100,
  finishsamples = 1000,
  lproughnesstarget = 0.2,
  verbose = 0,
  cores = 2,
  matsetup = NA,
  nsubsets = 10,
  stochasticTolAdjust = 1000
)
}
\arguments{
\item{standata}{list object conforming to rstan data standards.}

\item{sm}{compiled stan model object.}

\item{init}{vector of unconstrained parameter values, or character string 'random' to initialise with
random values very close to zero.}

\item{initsd}{positive numeric specifying sd of normal distribution governing random sample of init parameters,
if init='random' .}

\item{estonly}{if TRUE,just return point estimates under $rawest subobject.}

\item{tol}{objective tolerance.}

\item{stochastic}{Logical. Use stochastic gradient descent as main optimizer. Always finishes (double checks) with mize (bfgs) optimizer.}

\item{priors}{logical. If TRUE, a priors integer is set to 1 (TRUE) in the standata object -- only has an effect if 
the stan model uses this value.}

\item{carefulfit}{Logical. If TRUE, priors are always used for a rough first pass to obtain starting values when priors=FALSE}

\item{bootstrapUncertainty}{Logical. If TRUE, subject wise gradient contributions are resampled to estimate the hessian, 
for computing standard errors or initializing importance sampling.}

\item{subsamplesize}{value between 0 and 1 representing proportion of subjects to include in first pass fit.}

\item{parsteps}{ordered list of vectors of integers denoting which parameters should begin fixed
at zero, and freed sequentially (by list order). Useful for complex models, e.g. keep all cross couplings fixed to zero 
as a first step, free them in second step.}

\item{parstepsAutoModel}{if TRUE, determines model structure for the parameters specified in parsteps automatically. If 'group', determines this on a group level first and then a subject level. Primarily for internal ctsem use, see \code{?ctFitAuto}.}

\item{groupFreeThreshold}{threshold for determining whether a parameter is free in a group level model. If the proportion of subjects with a non-zero parameter is above this threshold, the parameter is considered free. Only used with parstepsAutoModel = 'group'.}

\item{plot}{Logical. If TRUE, plot iteration details. Probably slower.}

\item{is}{Logical. Use mixture importance sampling, or just return map estimates?}

\item{isitersize}{Number of samples of approximating distribution per iteration of importance sampling.}

\item{isESS}{target effective sample size for importance sampling. If is=TRUE, this is used to determine the number of samples to draw from the approximating distribution.}

\item{finishsamples}{Number of samples to draw (either from hessian
based covariance or posterior distribution) for final results computation.}

\item{lproughnesstarget}{target log posterior roughness for stochastic optimizer (suggest between .05 and .4).}

\item{verbose}{Integer from 0 to 2. Higher values print more information during model fit -- for debugging.}

\item{cores}{Number of cpu cores to use, should be at least 2.}

\item{matsetup}{subobject of ctStanFit output. If provided, parameter names instead of numbers are output for any problem indications.}

\item{nsubsets}{number of subsets for stochastic optimizer. Subsets are further split across cores, 
but each subjects data remains whole -- processed by one core in one subset.}

\item{stochasticTolAdjust}{Multiplier for stochastic optimizer tolerance.}
}
\value{
list containing fit elements
}
\description{
Optimize / importance sample a stan or ctStan model.
}
