% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanTIpredMarginal.R
\name{ctStanTIpredMarginal}
\alias{ctStanTIpredMarginal}
\title{Plot marginal relationships between covariates and parameters for a ctStanFit object.}
\usage{
ctStanTIpredMarginal(fit, tipred, pars, probs = c(0.025, 0.5, 0.975),
  useimputed = TRUE, plot = TRUE)
}
\arguments{
\item{fit}{ctStanFit object.}

\item{tipred}{Integer representing which tipred to use -- integer corresponds to TIpredNames specification.}

\item{pars}{Subject level matrices from the ctStanFit output -- e.g, 'DRIFT' or 'DIFFUSION'.}

\item{probs}{vector of 3 quantile probabilities, the 2nd will be plotted as a line, the 
outer two as shaded regions.}

\item{useimputed}{Logical, include imputed tipreds or only observed?}

\item{plot}{Logical, whether to plot.}
}
\value{
If \code{plot=TRUE}, nothing, otherwise an array that can be used with ctPlotArray.
}
\description{
Plot marginal relationships between covariates and parameters for a ctStanFit object.
}
\examples{
\donttest{
ctStanTIpredMarginal(ctstantestfit,pars='CINT',tipred=3)
}
}
