% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctPlotArray.R
\name{ctPlotArray}
\alias{ctPlotArray}
\title{Plots three dimensional y values for quantile plots}
\usage{
ctPlotArray(input, grid = FALSE, add = FALSE, colvec = "auto",
  lwdvec = "auto", ltyvec = "auto", typevec = "auto",
  plotcontrol = list(ylab = "Array values", xaxs = "i"), legend = TRUE,
  legendcontrol = list(), polygon = TRUE, polygonalpha = 0.1,
  polygoncontrol = list(steps = 25))
}
\arguments{
\item{input}{list containing 3 dimensional array to use for Y values, \code{$y}
and vector of corresponding x values \code{$x}.}

\item{grid}{Logical. Plot with a grid?}

\item{add}{Logical. If TRUE, plotting is overlayed on current plot, without creating new plot.}

\item{colvec}{color vector of same length as 2nd margin.}

\item{lwdvec}{lwd vector of same length as 2nd margin.}

\item{ltyvec}{lty vector of same length as 2nd margin.}

\item{typevec}{type vector of same length as 2nd margin.}

\item{plotcontrol}{list of arguments to pass to plot.}

\item{legend}{Logical. Draw a legend?}

\item{legendcontrol}{list of arguments to pass to \code{\link[graphics]{legend}}.}

\item{polygon}{Logical. Draw the uncertainty polygon?}

\item{polygonalpha}{Numeric, multiplier for alpha (transparency) of the 
uncertainty polygon.}

\item{polygoncontrol}{list of arguments to pass to \code{\link{ctPoly}}}
}
\value{
Nothing. Generates plots.
}
\description{
1st margin of $Y sets line values, 2nd sets variables, 3rd quantiles.
}
\examples{
\dontrun{
input<-ctStanTIpredeffects(ctstantestfit, plot=FALSE, whichpars='CINT', 
 nsamples=10,nsubjects=10)
    
ctPlotArray(input=input)
}
}
