% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinicaltrials_gov_version.R
\name{clinicaltrials_gov_version}
\alias{clinicaltrials_gov_version}
\title{Download a registry entry version from ClinicalTrials.gov}
\usage{
clinicaltrials_gov_version(nctid, versionno)
}
\arguments{
\item{nctid}{A character string including a well-formed
ClinicalTrials.gov NCT Number, e.g. "NCT00942747". (A
capitalized "NCT" followed by eight numerals with no spaces or
hyphens.)}

\item{versionno}{An integer version number, e.g. 1}
}
\value{
A list containing the overall status, enrolment, start
date, primary completion date, primary completion date type,
minimum age, maximum age, sex, gender-based, accepts healthy
volunteers, inclusion/exclusion criteria, outcome measures,
contacts and sponsors
}
\description{
Download a registry entry version from ClinicalTrials.gov
}
\examples{

\dontrun{
version <- clinicaltrials_gov_version("NCT00942747", 1)
}

}
