% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drks_de_download.R
\name{drks_de_download}
\alias{drks_de_download}
\title{Mass-download registry entry historical versions from DRKS.de}
\usage{
drks_de_download(drksids, output_filename)
}
\arguments{
\item{drksids}{A list of well-formed DRKS numbers,
e.g. c("DRKS00005219", "DRKS00003170").}

\item{output_filename}{A character string for a filename into which
the dataframe will be written as a CSV,
e.g. "historical_versions.csv".}
}
\value{
On successful completion, returns TRUE, otherwise returns
FALSE. If the function is called again with the same DRKS
numbers and output filename, it will check the output file for
errors in the download, remove them and try to download the
historical versions again.
}
\description{
Mass-download registry entry historical versions from DRKS.de
}
\examples{

\dontrun{
filename <- tempfile()
drks_de_download(c("DRKS00005219", "DRKS00003170"), filename)
}

}
