% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranks_multinom.R
\name{csranks_multinom}
\alias{csranks_multinom}
\title{Confidence sets for ranks based on multinomial data}
\usage{
csranks_multinom(
  x,
  coverage = 0.95,
  cstype = "two-sided",
  simul = TRUE,
  multcorr = "Holm",
  indices = NA,
  na.rm = FALSE
)
}
\arguments{
\item{x}{vector of counts of successes for each category}

\item{coverage}{nominal coverage of the confidence set. Default is 0.95.}

\item{cstype}{type of confidence set (\code{two-sided}, \code{upper}, \code{lower}). Default is \code{two-sided}.}

\item{simul}{logical; if \code{TRUE} (default), then simultaneous confidence sets are computed, which jointly cover all populations indicated by \code{indices}.
Otherwise, for each population indicated in \code{indices} a marginal confidence set is computed.}

\item{multcorr}{multiplicity correction to be used: \code{Holm} (default) or \code{Bonferroni}. See Details section for more.}

\item{indices}{vector of indices of \code{x} for whose ranks the confidence sets are computed. \code{indices=NA} (default) means computation for all ranks.}

\item{na.rm}{logical; if \code{TRUE}, then \code{NA}'s are removed from \code{x} and \code{Sigma} (if any).}
}
\value{
A \code{csranks} object, which is a list with three items:
\describe{
 \item{\code{L}}{Lower bounds of the confidence sets for ranks indicated in \code{indices}}
 \item{\code{rank}}{Raw rank estimates using \code{\link{irank}} with default parameters}
 \item{\code{U}}{Upper bounds of the confidence sets.}
}
}
\description{
Given data on counts of successes for each category, calculate confidence sets for the ranks of categories, where categories are ranked by their success probabilities.
}
\section{Details}{

The command implements the procedure for construction of confidence sets for ranks described in the referenced paper below.

It involves testing multiple hypotheses. The `\code{multcorr}` states, how the 
p-values should be corrected to control the Family Wise Error Rate (FWER).

From a practical point of view, \code{multcorr=Holm} takes more time, but usually results
in tighter (better) confidence sets than \code{multcorr=Bonferroni}.
}

\examples{
x <- c(rmultinom(1, 1000, 1:10))
csranks_multinom(x)
}
\references{
Bazylik, Mogstad, Romano, Shaikh, and Wilhelm.
"Finite-and large-sample inference for ranks using multinomial data with an application to ranking political parties".
}
