% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{filter.csquares}
\alias{filter.csquares}
\alias{select.csquares}
\alias{as_tibble.csquares}
\alias{arrange.csquares}
\alias{group_by.csquares}
\alias{ungroup.csquares}
\alias{rowwise.csquares}
\alias{mutate.csquares}
\alias{rename.csquares}
\alias{rename_with.csquares}
\alias{slice.csquares}
\alias{distinct.csquares}
\alias{summarise.csquares}
\alias{pivot_longer.csquares}
\alias{pivot_wider.csquares}
\alias{group_split.csquares}
\alias{unite.csquares}
\alias{unnest.csquares}
\alias{unnest.csquares_nested}
\alias{drop_na.csquares}
\title{Tidyverse methods for csquares objects (drop the 'csquares'-suffix)}
\usage{
filter.csquares(.data, ..., .dots)

select.csquares(.data, ...)

as_tibble.csquares(x, ...)

arrange.csquares(.data, ..., .dots)

group_by.csquares(.data, ..., add = FALSE)

ungroup.csquares(.data, ...)

rowwise.csquares(.data, ...)

mutate.csquares(.data, ..., .dots)

rename.csquares(.data, ...)

rename_with.csquares(.data, .fn, .cols, ...)

slice.csquares(.data, ..., .dots)

distinct.csquares(.data, ..., .keep_all = FALSE)

summarise.csquares(.data, ..., .dots)

pivot_longer.csquares(
  data,
  cols,
  ...,
  cols_vary = "fastest",
  names_to = "name",
  names_prefix = NULL,
  names_sep = NULL,
  names_pattern = NULL,
  names_ptypes = NULL,
  names_transform = NULL,
  names_repair = "check_unique",
  values_to = "value",
  values_drop_na = FALSE,
  values_ptypes = NULL,
  values_transform = NULL
)

pivot_wider.csquares(
  data,
  ...,
  id_cols = NULL,
  id_expand = FALSE,
  names_from = NULL,
  names_prefix = "",
  names_sep = "_",
  names_glue = NULL,
  names_sort = FALSE,
  names_vary = "fastest",
  names_expand = FALSE,
  names_repair = "check_unique",
  values_from = NULL,
  values_fill = NULL,
  values_fn = NULL,
  unused_fn = NULL
)

group_split.csquares(.tbl, ..., .keep = TRUE)

unite.csquares(data, col, ..., sep = "_", remove = TRUE)

unnest.csquares(data, ..., .preserve = NULL)

unnest.csquares_nested(data, ..., .preserve = NULL)

drop_na.csquares(x, ...)
}
\arguments{
\item{.data, ..., .dots, data, x, add, .fn, .cols, .keep_all, cols, cols_vary, names_to, names_prefix, names_sep, names_pattern, names_ptypes, names_transform, names_repair, values_to, values_drop_na, values_ptypes, values_transform, id_cols, id_expand, names_from, names_glue, names_sort, names_vary, names_expand, values_from, values_fill, values_fn, unused_fn, .tbl, .keep, col, sep, remove, .preserve}{Passed to tidyverse generic methods. Consult their documentation.}
}
\description{
Tidyverse methods for \code{csquares} objects that inherit from \code{data.frame}, \code{tibble}, \code{sf}, or
in some cases \code{stars}. Load the tidyverse package containing the generic implementation (\code{dplyr} or \code{tidyr}),
and call the function without the \code{.csquares} suffix.
See examples for more details. The methods implemented here ensure that the \code{csquare} class is preserved.
}
\details{
Note that the implementation of \code{summarise.csquares} has changed since version 0.0.5.002, to better
reflect the \code{dplyr} generic implementation. To get results similar to the earlier implementation please
use \code{resample_csquares()}.
}
\examples{
if (requireNamespace(c("dplyr", "tidyr"))) {
  library(dplyr)
  library(tidyr)
  
  ## Create a csquares object from the orca dataset:
  orca_csq <- as_csquares(orca, csquares = "csquares")
  
  ## Filter values that belong to the killer whale realm:
  orca2 <- filter(orca_csq, orcinus_orca == TRUE)
  
  ## Mutate the object to hold information on the quadrant:
  orca_csq <- mutate(orca_csq, quadrant = csquares |> as.character() |> substr(1,1))
  
  ## Select the quadrant column:
  orca2 <- select(orca_csq, quadrant)
  
  ## Convert it into a tibble:
  orca_csq <- as_tibble(orca_csq)
  
  ## Arrange by quadrant:
  orca2 <- arrange(orca_csq, quadrant)
  
  ## Group by quadrant:
  orca_csq <- group_by(orca_csq, quadrant)
  
  ## Summarise per quadrant:
  summarise(orca_csq, realm_frac = sum(orcinus_orca)/n())
  
  #' Introduce a group split:
  orca2 <- group_split(orca_csq)
  
  ## Ungroup the object:
  orca_csq <- ungroup(orca_csq)
  
  ## Take a slice of the first three rows:
  slice(orca_csq, 1:3)
  
  ## Take a sample of 10 rows with replacement:
  slice_sample(orca_csq, n = 10, replace = TRUE)
  
  ## Rename a column:
  rename(orca_csq, quad = "quadrant")
  rename_with(orca_csq, toupper, starts_with("quad"))
  
  ## Distinct will remove any duplicated rows:
  orca_csq[c(1, 1, 1),] |> distinct()
  
  ## Pivot to a wide format:
  pivot_wider(orca_csq, names_from = "quadrant", values_from = "orcinus_orca")
  pivot_wider(orca_csq, names_from = "orcinus_orca", values_from = "orcinus_orca",
              id_cols = "quadrant", values_fn = length)
  
  ## Pivot to a long format (note that you can't pivot the csquares column to long)
  tibble(csq = "1000", a = 1, b = 2, d = 3) |>
    as_csquares(csquares = "csq") |>
    pivot_longer(c("a", "b", "d"), names_to = "letter", values_to = "numeric")
  
  ## Unite two columns into one:
  unite(orca_csq, "quad_realm", any_of(c("quadrant", "orcinus_orca")))
  
  ## As the csquares column gets nested in the example below,
  ## the resulting object is no longer of class csquares:
  orca_nest <- nest(orca_csq, nested_data = c("csquares", "orcinus_orca"))
  
  ## Unnest it:
  unnest(orca_nest, "nested_data")
}

}
\author{
Pepijn de Vries
}
