% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validation}
\alias{validation}
\title{Validate Model Predictions}
\usage{
validation(
  predicted = NULL,
  outcomeType = c("binary", "continuous", "time-to-event"),
  trueY = NULL,
  time = NULL,
  trueEvent = NULL,
  baseHz = NULL,
  u = 2,
  outfile = "nameWithPath"
)
}
\arguments{
\item{predicted}{A vector of model prediction values, which can be generated by prediction functions in this package such as LASSO_predict and XGBtraining_predict. For continuous outcomes, this vector represents model scores; for binary outcomes, it represents the probability of the positive class; for time-to-event outcomes, it contains risk scores, which will later be transformed into estimated survival probabilities corresponding to times in the new data.}

\item{outcomeType}{Outcome variable type. There are three choices: "binary" (default), "continuous", and "time-to-event".}

\item{trueY}{A vector of outcome variable when it is continuous or binary}

\item{time}{A vector of time for time to event outcome}

\item{trueEvent}{A vector of event for time to event outcome}

\item{baseHz}{A table for accumulate baseline hazard for multiple time points, which is usually generated based on a training data set.}

\item{u}{A single numeric follow-up time for survival outcomes.}

\item{outfile}{A string for the output file including path if necessary but without file type extension. 
If you run LASSO or XGBtraining function to get the training model, the 2nd item in the returned list is the "baseHz".}
}
\value{
A vector of model prediction values from input
}
\description{
This function is designed to perform model validation when the outcome variable is available. It facilitates the comparison of model predictions with the provided outcome variable, which can be continuous, binary, or time-to-event.
}
\details{
This function is invoked by multiple prediction functions within this package when an outcome variable is available for a new dataset. However, users can also directly call this function if needed. While comparison...
}
\examples{
# Load in data sets:
data("datlist", package = "csmpv")
tdat = datlist$training
vdat = datlist$validation

# The function saves files locally. You can define your own temporary directory. 
# If not, tempdir() can be used to get the system's temporary directory.
temp_dir = tempdir()
# As an example, let's define Xvars, which will be used later:
Xvars = c("highIPI", "B.Symptoms", "MYC.IHC", "BCL2.IHC", "CD10.IHC", "BCL6.IHC")

# The function can work with multiple models and multiple outcome types. 
# Here, we use XGBoost model with binary outcome as an example:
bxfit = XGBtraining(data = tdat, biomks = Xvars, Y = "DZsig",
                    outfile = paste0(temp_dir, "/binary_XGBoost"))
testdat = vdat[,bxfit$XGBoost_model$feature_names]
test = xgboost::xgb.DMatrix(data.matrix(testdat))
scores = stats::predict(bxfit$XGBoost_model, test) 
names(scores) = rownames(vdat)
Y = bxfit$Y
outs = validation(predicted = scores, outcomeType = "binary", trueY = vdat[,Y],
                  outfile = paste0(temp_dir, "/binary_XGBoost_validate")) 
# You might save the files to the directory you want.

# To delete the temp_dir, use the following:
unlink(temp_dir)
}
\references{
Harrell Jr F (2023). rms: Regression Modeling Strategies_. R package version 6.7-1, <https://CRAN.R-project.org/package=rms>
  Harrell Jr F (2023). Hmisc: Harrell Miscellaneous_. R package version 5.1-1, <https://CRAN.R-project.org/package=Hmisc>
}
