/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.Capabilities;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.WMService;
import com.vividsolutions.wms.util.XMLTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Parser {
    public Capabilities parseCapabilities(WMService service, InputStream inStream) throws IOException {
        Document doc;
        MapLayer topLayer = null;
        String title = null;
        LinkedList<String> formatList = new LinkedList<String>();
        try {
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.parse(new InputSource(inStream));
            doc = parser.getDocument();
        }
        catch (SAXException saxe) {
            throw new IOException(saxe.toString());
        }
        try {
            title = ((CharacterData)XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Service/Title").getFirstChild()).getData();
        }
        catch (Exception e) {
            // empty catch block
        }
        Node formatNode = XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Request/Map/Format");
        NodeList nl = formatNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            formatList.add(n.getNodeName());
        }
        topLayer = this.wmsLayerFromNode(XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Layer"));
        return new Capabilities(service, title, topLayer, formatList);
    }

    public MapLayer wmsLayerFromNode(Node layerNode) {
        String name = null;
        String title = null;
        LinkedList<String> srsList = new LinkedList<String>();
        LinkedList<MapLayer> subLayers = new LinkedList<MapLayer>();
        BoundingBox bbox = null;
        NodeList nl = layerNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            try {
                if (n.getNodeType() != 1) continue;
                if (n.getNodeName().equals("Name")) {
                    name = ((CharacterData)n.getFirstChild()).getData();
                    continue;
                }
                if (n.getNodeName().equals("Title")) {
                    title = ((CharacterData)n.getFirstChild()).getData();
                    continue;
                }
                if (n.getNodeName().equals("SRS")) {
                    String srsStr = ((CharacterData)n.getFirstChild()).getData();
                    while (srsStr.length() > 0) {
                        int ws = srsStr.indexOf(32);
                        if (ws > 0) {
                            srsList.add(srsStr.substring(0, ws));
                            srsStr = srsStr.substring(ws + 1);
                            continue;
                        }
                        if (srsStr.length() <= 0) continue;
                        srsList.add(srsStr);
                        srsStr = "";
                    }
                    continue;
                }
                if (n.getNodeName().equals("LatLonBoundingBox")) {
                    bbox = this.boundingBoxFromNode(n);
                    continue;
                }
                if (!n.getNodeName().equals("Layer")) continue;
                subLayers.add(this.wmsLayerFromNode(n));
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception caught in wmsLayerFromNode(): " + e.toString());
            }
        }
        return new MapLayer(name, title, srsList, subLayers, bbox);
    }

    public BoundingBox boundingBoxFromNode(Node n) throws Exception {
        try {
            String srs;
            NamedNodeMap nm = n.getAttributes();
            if (n.getNodeName().equals("LatLonBoundingBox")) {
                srs = "LatLon";
            } else if (n.getNodeName().equals("BoundingBox")) {
                srs = nm.getNamedItem("SRS").getNodeValue();
            } else {
                throw new Exception("Not a (LatLon)BoundingBox Element");
            }
            double minx = nm.getNamedItem("minx").getNodeValue().equals("inf") ? Double.parseDouble("-Infinity") : Double.parseDouble(nm.getNamedItem("minx").getNodeValue());
            double miny = nm.getNamedItem("miny").getNodeValue().equals("inf") ? Double.parseDouble("-Infinity") : Double.parseDouble(nm.getNamedItem("miny").getNodeValue());
            double maxx = nm.getNamedItem("maxx").getNodeValue().equals("inf") ? Double.parseDouble("+Infinity") : Double.parseDouble(nm.getNamedItem("maxx").getNodeValue());
            double maxy = nm.getNamedItem("maxy").getNodeValue().equals("inf") ? Double.parseDouble("+Infinity") : Double.parseDouble(nm.getNamedItem("maxy").getNodeValue());
            return new BoundingBox(srs, minx, miny, maxx, maxy);
        }
        catch (Exception e) {
            throw new Exception("Invalid bounding box element node: " + e.toString());
        }
    }
}

