/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;

public class AffineTransControlPointExtracter {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_VECTOR = 1;
    public static final int TYPE_LINE_3 = 2;
    private FeatureCollection fcSrc;
    private FeatureCollection fcDest;
    private int inputType = 0;
    private String parseErrMsg = "Unrecognized control point geometry";
    private int numGeoms;
    private Geometry[] geomSrc = new Geometry[3];
    private Geometry[] geomDest = new Geometry[3];
    private int numControlPts;
    private Coordinate[] controlPtSrc;
    private Coordinate[] controlPtDest;

    public AffineTransControlPointExtracter(FeatureCollection fcSrc, FeatureCollection fcDest) {
        this.fcSrc = fcSrc;
        this.fcDest = fcDest;
        this.init();
    }

    public int getInputType() {
        return this.inputType;
    }

    public String getParseErrorMessage() {
        return this.parseErrMsg;
    }

    public Coordinate[] getSrcControlPoints() {
        return this.controlPtSrc;
    }

    public Coordinate[] getDestControlPoints() {
        return this.controlPtDest;
    }

    private void init() {
        this.parseInput();
    }

    private void parseInput() {
        int fcDestSize;
        this.inputType = 0;
        int fcSrcSize = this.fcSrc.size();
        if (fcSrcSize != (fcDestSize = this.fcDest.size())) {
            this.parseErrMsg = "Control point collections must be same size";
            return;
        }
        if (fcSrcSize != 1) {
            this.parseErrMsg = "Control points must be a single geometry";
            return;
        }
        this.geomSrc[0] = ((Feature)this.fcSrc.iterator().next()).getGeometry();
        this.geomDest[0] = ((Feature)this.fcDest.iterator().next()).getGeometry();
        if (this.geomSrc[0].getClass() != this.geomDest[0].getClass()) {
            this.parseErrMsg = "Control points must be LineStrings";
            return;
        }
        if (!(this.geomSrc[0] instanceof LineString)) {
            this.parseErrMsg = "Control points must be LineStrings";
            return;
        }
        this.parseLines();
    }

    private void parseLines() {
        this.controlPtSrc = this.geomSrc[0].getCoordinates();
        this.controlPtDest = this.geomDest[0].getCoordinates();
        if (this.controlPtSrc.length != this.controlPtDest.length) {
            this.parseErrMsg = "Control Point LineStrings are different lengths";
            return;
        }
        if (this.controlPtSrc.length < 2) {
            this.parseErrMsg = "Single control points are not supported";
        }
        if (this.controlPtSrc.length > 3) {
            this.parseErrMsg = "Too many points in LineString";
        }
        this.inputType = 1;
    }
}

