% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper.R
\name{scraper}
\alias{scraper}
\title{Historical table scraper}
\usage{
scraper(attributes, slug, sleep = NULL)
}
\arguments{
\item{attributes}{URL generated from \code{listCoins()}}

\item{slug}{Unique identifier required for merging}

\item{sleep}{Duration to sleep to resolve rate limiter}
}
\value{
Raw OHLC market data in a dataframe:
  \item{slug}{Coin url slug}
  \item{symbol}{Coin symbol}
  \item{name}{Coin name}
  \item{date}{Market date}
  \item{open}{Market open}
  \item{high}{Market high}
  \item{low}{Market low}
  \item{close}{Market close}
  \item{volume}{Volume 24 hours}
  \item{market}{USD Market cap}
}
\description{
This web scrapes the historic price tables from CoinMarketCap
and provides back a dataframe for the coin provided as an input.
This function is a dependency of getCoins and is used
as part of a loop to retrieve all crypto currencies.
}
