% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry_S3.R
\name{cryst_symm}
\alias{cryst_symm}
\title{Constructor for an S3 object of class "cryst_symm".}
\usage{
cryst_symm(SG = NULL, set = NULL)
}
\arguments{
\item{SG}{A character string or an integer identifying the space group. There are 230
used space group in crystallography and each one corresponds to a unique and so-called
extended Hermann-Mauguin symbol. An example is space group number 19, identified by the
extended Hermann-Mauguin symbol "P 21 21 21". Several formats are possible and some of them
are now rarely used. Attempts are made to transform the input into a correct Hermann-Mauguin
symbol, but if all fails, a warning is raised and the space group P 1 is assigned.}

\item{set}{An integer defining which setting of many possible for the given space group. Some
crystallographic space groups can be implemented with small variants known as "settings".
If the input SG is an extended Hermann-Mauguin symbol, set is ignored, as it is already
specified by the xHM symbol.}
}
\value{
An object of class "cryst_symm". It is a named list of length 4. The names are, "SG",
 "PG", "T" and "C".
\itemize{
 \item{1) SG. This is a string containing the correct extended Hermann-Mauguin symbol.}
 \item{2) PG. This is a list whose elements are all the \eqn{3\times 3} matrices forming
              the point-group part of the symmetry transformation.}
 \item{3) T. This is a list whose elements are all the \eqn{3\times 1} vectors forming
              the translational part of the symmetry transformation.}
 \item{4) C. This is a list whose elements are all the \eqn{3\times 1} vectors forming
              the centering of the unit cell.}
}
}
\description{
This represents a crystallographic space group.
}
\details{
The constructor can be used with less than the full set of two input parameters,
to create an object of class cryst_symm corresponding to space group P 1. If the input
string is not recognised, a warning is raised and space group P 1 is assigned.
}
\examples{
# The symplest symmetry: P 1
crsym <- cryst_symm("P 1")
print(crsym)

# The second space group: P -1
crsym <- cryst_symm(2)
print(crsym)

# Something more complicated
crsym <- cryst_symm("P 21 21 21")
print(crsym)

}
