% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crunchy-ui.R
\name{crunchyBody}
\alias{crunchyBody}
\title{A Shiny UI with Crunch auth}
\usage{
crunchyBody(...)
}
\arguments{
\item{...}{UI elements for your app}
}
\value{
A \code{uiOutput()} container into which \code{crunchyServer()} will
conditionally render output.
}
\description{
When using \code{\link[=crunchyServer]{crunchyServer()}} to wrap your app in Crunch authentication and
authorization, you need to wrap your UI body content inside \code{crunchyBody()}.
}
\details{
This is the part that is conditionally rendered if the user is allowed.
Any UI elements you want always to show, including \code{<head>} tags, should go
outside this function.
}
\examples{
\dontrun{
shinyUI(fluidPage(
    tags$head(
        # This is content that will always be rendered
        tags$title("My secure app")
    ),
    crunchyBody(
        # This is content that only is rendered if the user is authorized
        fluidRow(
            column(6, h1("Column 1")),
            column(6, h1("Column 2"))
        )
    )
))
}
}
\seealso{
\code{\link[=crunchyPublicBody]{crunchyPublicBody()}} \code{\link[=crunchyServer]{crunchyServer()}}
}
