% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/variable-derivation.R
\name{derivation}
\alias{derivation}
\alias{derivation<-}
\alias{is.derived}
\alias{is.derived<-}
\alias{derivations}
\alias{derivation,CrunchVariable-method}
\alias{derivation<-,CrunchVariable,ANY-method}
\alias{derivation<-,CrunchVariable,NULL-method}
\alias{is.derived,CrunchVariable-method}
\alias{is.derived<-,CrunchVariable,logical-method}
\title{Get or set a derived variable's expression}
\usage{
derivation(x)

derivation(x) <- value

is.derived(x)

is.derived(x) <- value

\S4method{derivation}{CrunchVariable}(x)

\S4method{derivation}{CrunchVariable,ANY}(x) <- value

\S4method{derivation}{CrunchVariable,NULL}(x) <- value

\S4method{is.derived}{CrunchVariable}(x)

\S4method{is.derived}{CrunchVariable,logical}(x) <- value
}
\arguments{
\item{x}{a variable}

\item{value}{a \code{CrunchExpr} to be used as the derivation (for the setter
only) or \code{NULL} to integrate a derived variable. For \code{is.derived}, \code{FALSE}
can be used to integrate a derived variable.}
}
\value{
a \code{CrunchExpr} of the derivation for \code{derivation}; a logical for
\code{is.derived}; the variable given in \code{x} for \verb{is.derived<-} returns
}
\description{
Get a derived variable's derivation formula as a \link[=expressions]{CrunchExpr} with
\code{derivation(variable)}. Set (change) a derived variable's derivation with
\code{derivation(variable) <- expression}.
}
\details{
To break a derivation link between a derived variable and the originating variable, set
the derivation value of the derived variable to \code{NULL} with \code{derivation(variable) <- NULL}

\code{is.derived} can be used to see if a variable is derived or not. Additionally
setting a derived variable's \code{is.derived} to \code{FALSE} will break the derivation link between
two variables.
}
\examples{
\dontrun{

ds$derived_v1 <- ds$v1 + 5

derivation(ds$derived_v1)
# Crunch expression: v1 + 5

derivation(ds$derived_v1) <- ds$v1 + 10
derivation(ds$derived_v1)
# Crunch expression: v1 + 10

is.derived(ds$derived_v1)
# TRUE

# to integrate or instantiate the variable in place (remove the link between
# variable v1 and the derivation) you can:
derivation(ds$derived_v1) <- NULL

# after integrating, the derived variable is no longer derived.
is.derived(ds$derived_v1)
# FALSE

# Derivations can be updated with arbitrary expressions.
# Consider a numeric case variable that combines weights
# calculated separately in a separate variable
# for each of several waves:
ds$weight <- makeCaseWhenVariable(
    ds$wave == 1 ~ ds$weight_wave1,
    ds$wave == 2 ~ ds$weight_wave2,
    ds$wave == 3 ~ ds$weight_wave3,
    name = "Weight"
)

# When a new wave is added, update the derivation
# of the weight to add the new condition and source
# column.
derivation(ds$weight) <- caseWhenExpr(
    ds$wave == 1 ~ ds$weight_wave1,
    ds$wave == 2 ~ ds$weight_wave2,
    ds$wave == 3 ~ ds$weight_wave3,
    ds$wave == 4 ~ ds$weight_wave4
)
}
}
