% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{crs4hc}
\alias{crs4hc}
\title{Estimation of Nonlinear Regression Parameters with CRS4HC}
\usage{
crs4hc(formula, data, a, b, N, my_eps, max_evals, delta, w0)
}
\arguments{
\item{formula}{(obligatory) a nonlinear \link{formula} including variables and parameters}

\item{data}{(obligatory) data frame in which to evaluate the variables in \code{formula}}

\item{a}{(obligatory) a vector of length equal to number of parameters representing lower bounds of search space (bounds for parameters must be specified in the same order they appear on right-hand side of \code{formula})}

\item{b}{(obligatory) a vector of length equal to number of parameters representing upper bounds of search space (bounds for parameters must be specified in the same order they appear on right-hand side of \code{formula})}

\item{N}{(optional) size of population}

\item{my_eps}{(optional) is used for stopping condition}

\item{max_evals}{(optional) is used for stopping condition, specifies maximum number of objective function evaluations per dimension (dimension=nonlinear model parameter)}

\item{delta}{(optional) controls the competition of local heuristics}

\item{w0}{(optional) controls the competition of local heuristics}
}
\value{
An S3 object of class \code{crs4hc}. This object is a list of:
  \item{model}{a list of two items, includes estimates of nonlinear model parameters and minimal residual sum of squares}
  \item{algorithmInfo}{a list of three items with some internal info about algorithm run}
  \item{data}{a data frame that was passed to function as the \code{data} argument}
  \item{other}{a list of four items which include info about nonlinear model \code{formula}}
}
\description{
This function estimates the regression coefficients of a nonlinear regression function using least squares.
The minimization is performed by the CRS algorithm with four competing local heuristics. Algorithm is described in Tvrdík, Křivý and Mišík (2007).
}
\details{
There are implemented methods for generic functions \link{print}, \link{summary}, \link{plot}.
}
\examples{
x <- c(1,2,3,5,7,10)
y <- c(109,149,149,191,213,224)
df <- data.frame(x=x, y=y)
lowerBounds <- c(1, 0.1)
upperBounds <- c(1000, 2)
mod <- crs4hc(y ~ b1 * (1-exp(-b2*x)), df, lowerBounds, upperBounds)
mod

}
\references{
Tvrdík, J., Křivý, I., and Mišík, L. Adaptive Population-based search:
Application to Estimation of Nonlinear Regression Parameters. \emph{Computational
Statistics and Data Analysis 52} (2007), 713–724. Preprint URL \url{http://www1.osu.cz/~tvrdik/wp-content/uploads/CSDA-06SAS03e.pdf}
}

