% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-class.R
\docType{class}
\name{PseudoDualSimulations-class}
\alias{PseudoDualSimulations-class}
\alias{.PseudoDualSimulations}
\alias{PseudoDualSimulations}
\alias{.DefaultPseudoDualSimulations}
\title{\code{PseudoDualSimulations}}
\usage{
PseudoDualSimulations(
  fit_eff,
  final_gstar_estimates,
  final_gstar_at_dose_grid,
  final_gstar_cis,
  final_gstar_ratios,
  final_optimal_dose,
  final_optimal_dose_at_dose_grid,
  sigma2_est,
  ...
)

.DefaultPseudoDualSimulations()
}
\arguments{
\item{fit_eff}{(\code{list})\cr see slot definition.}

\item{final_gstar_estimates}{(\code{numeric})\cr see slot definition.}

\item{final_gstar_at_dose_grid}{(\code{numeric})\cr see slot definition.}

\item{final_gstar_cis}{(\code{list})\cr see slot definition.}

\item{final_gstar_ratios}{(\code{numeric})\cr see slot definition.}

\item{final_optimal_dose}{(\code{numeric})\cr see slot definition.}

\item{final_optimal_dose_at_dose_grid}{(\code{numeric})\cr see slot definition.}

\item{sigma2_est}{(\code{numeric})\cr see slot definition.}

\item{\dots}{additional parameters from \code{\link{PseudoSimulations}}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
This class conducts trial simulations for designs using both the
DLE and efficacy responses. It defines final values for
efficacy fit and DLE, estimates of Gstar, optimal dose and sigma2.
}
\section{Slots}{

\describe{
\item{\code{fit_eff}}{(\code{list})\cr final values of efficacy fit.}

\item{\code{final_gstar_estimates}}{(\code{numeric})\cr final Gstar estimates.}

\item{\code{final_gstar_at_dose_grid}}{(\code{numeric})\cr final Gstar estimates at dose grid.}

\item{\code{final_gstar_cis}}{(\code{list})\cr list of 95\% confidence interval for Gstar estimates.}

\item{\code{final_gstar_ratios}}{(\code{numeric})\cr ratios of confidence intervals for Gstar estimates.}

\item{\code{final_optimal_dose}}{(\code{numeric})\cr final optimal dose.}

\item{\code{final_optimal_dose_at_dose_grid}}{(\code{numeric})\cr final optimal dose at dose grid.}

\item{\code{sigma2_est}}{(\code{numeric})\cr final sigma2 estimates.}
}}

\note{
Do not use the \code{.DefaultPseudoDualSimulations()} function.
}
