% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{StoppingList-class}
\alias{StoppingList-class}
\alias{.StoppingList}
\title{Stop based on multiple stopping rules}
\description{
This class can be used to combine multiple stopping rules.
}
\details{
\code{stopList} contains all stopping rules, which are again objects of
class \code{\linkS4class{Stopping}}, and the \code{summary} is a function
taking a logical vector of the size of \code{stopList} and returning a
single logical value. For example, if the function \code{all} is given as
\code{summary} function, then this means that all stopping rules must be
fulfilled in order that the result of this rule is to stop.
}
\section{Slots}{

\describe{
\item{\code{stopList}}{list of stopping rules}

\item{\code{summary}}{the summary function to combine the results of the stopping
rules into a single result}
}}

\examples{

# Define some stopping rules
myStopping1 <- StoppingMinCohorts(nCohorts=3)
myStopping2 <- StoppingTargetProb(target=c(0.2, 0.35),
                                  prob=0.5)
myStopping3 <- StoppingMinPatients(nPatients=20)

# Create a list of stopping rules (of class 'StoppingList') which will then be
# summarized (in this specific example) with the 'any' function, meaning that the study 
# would be stopped if 'any' of the single stopping rules is TRUE.
mystopping <- StoppingList(stopList=c(myStopping1,myStopping2,myStopping3),
                           summary=any)


}
\keyword{classes}
