% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestMaxGainSamples-class}
\alias{.NextBestMaxGainSamples}
\alias{NextBestMaxGainSamples-class}
\title{Next best dose with maximum gain value based on a pseudo DLE and efficacy model with samples}
\description{
This is a class for which to find the next dose which is safe and give the maximum gain value 
for allocation. This is a class where DLE and efficacy samples are involved.
There are two inputs which are the two target 
probabilities of the occurrence of a DLE used during trial
and used at the end of trial, for finding the next best dose that is safe and gives the maximum 
gain value and the dose to recommend at the end of a trial. This is only suitable to use with DLE models
specified in 'ModelTox' class and efficacy models  specified in 'ModelEff' class
class
}
\section{Slots}{

\describe{
\item{\code{DLEDuringTrialtarget}}{the target probability of the occurrrence of a DLE to be used
during the trial}

\item{\code{DLEEndOfTrialtarget}}{the target probability of the occurrence of a DLE to be used at the end 
of the trial. This target is particularly used to recommend the dose for which its posterior 
probability of the occurrence of a DLE is equal to this target}

\item{\code{TDderive}}{the function which derives from the input, a vector of the posterior samples called 
\code{TDsamples} of the dose
which has the probability of the occurrence of DLE equals to either the targetDuringTrial or
targetEndOfTrial, the final next best TDtargetDuringTrial (the dose with probability of the 
occurrence of DLE equals to the targetDuringTrial)and TDtargetEndOfTrial estimate.}

\item{\code{Gstarderive}}{the function which derives from the input, a vector of the posterior Gstar (the dose
which gives the maximum gain value) samples 
called \code{Gstarsamples}, the final next best Gstar estimate.}
}}
\examples{
##define the NextBestMaxGainsamples class
##specified the target probability of the occurrence of a DLE during the trial be 0.35
##specified the target probability of the occurrence of a DLE at the end of trial be 0.3
## we want the use the 30\% posterior quantile (the 30th percentaile) of the TD35 
## (the dose level with probability of DLE equals 0.35) and TD30 samples
## For Gstar (the dose which gives tha maximum
##gain) samples, we will use the 50\% posterio quantile (the median or th 50th percentile) 
## of the Gstar sample
##A function is then defined in the 'TDderive' slot for the TD30 and TD35 samples
## and another function is defined in the 'Gstarderive' slot for Gstar samples
mynextbest<-NextBestMaxGainSamples(DLEDuringTrialtarget=0.35,
                                   DLEEndOfTrialtarget=0.3,
                                   TDderive=function(TDsamples){
                                     quantile(TDsamples,prob=0.3)},
                                   Gstarderive=function(Gstarsamples){
                                     quantile(Gstarsamples,prob=0.5)})
}
\keyword{class}

