% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/caseUtils.R
\name{makePairs}
\alias{makeLinked}
\alias{makePairs}
\alias{makeUnlinked}
\title{Generates indices of linked and unlinked crime pairs (with weights)}
\usage{
makePairs(X, thres = 365, m = 40, show.pb = FALSE)

makeLinked(X, thres = 365)

makeUnlinked(X, m, thres = 365, show.pb = FALSE)
}
\arguments{
\item{X}{crime series data (generated from \code{\link{makeSeriesData}})
  with offender ID (\code{offenderID}),
  crime ID (\code{crimeID}), and the event datetime (\code{TIME})}

\item{thres}{the threshold (in days) of allowable time distance}

\item{m}{the number of samples from each crime group (for unlinked pairs)}

\item{show.pb}{(logical) should a progress bar be displayed}
}
\value{
matrix of indices of crime pairs with weights. For \code{makePairs},
  The last column \code{type} indicates if the crime pair is linked or unlinked.
}
\description{
These functions generate a set of crimeIDs for linked and unlinked crime pairs.
   Linked pairs are assigned a weight according to how many crimes are in the
   crime series. For unlinked pairs, \code{m} crimes are selected from each
   \emph{crime group} and pairs them with crimes in other \emph{crime groups}.
}
\details{
\code{makePairs} is a Convenience function that calls \code{makeLinked} and
  \code{makeUnlinked} and combines the results. It is unlikely that the latter
  two functions will need to be called directly

  For \emph{linked} crime pairs, the weights are such that each crime
  series only gives a total weight of 1. Due to co-offending, the sum of weights
  will be smaller than the number of series with at least two crimes.

  To form the \emph{unlinked} crime pairs, \emph{crime groups} are identifyed
  as the maximal connected offender subgraphs. Then \code{m} indices are drawn
  from each crime group and paired with crimes from other crime groups according
  to weights to ensure that large groups don't give the most events.
}
\examples{
data(crimes)
 data(offenders)
 seriesData = makeSeriesData(crimedata=crimes,offenderTable=offenders)
 allPairs = makePairs(seriesData,thres=365,m=40)
}

