% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller.R
\name{crew_class_controller}
\alias{crew_class_controller}
\title{Controller class}
\description{
\code{R6} class for controllers.
}
\details{
See \code{\link[=crew_controller]{crew_controller()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
router <- crew_router()
launcher <- crew_launcher_local()
controller <- crew_controller(router = router, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}

## ------------------------------------------------
## Method `crew_class_controller$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
router <- crew_router()
launcher <- crew_launcher_local()
controller <- crew_controller(router = router, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}
}
\seealso{
Other controllers: 
\code{\link{crew_class_controller_group}},
\code{\link{crew_controller_group}()},
\code{\link{crew_controller_local}()},
\code{\link{crew_controller}()}
}
\concept{controllers}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{router}}{Router object.}

\item{\code{launcher}}{Launcher object.}

\item{\code{queue}}{List of tasks in the queue.}

\item{\code{results}}{List of finished tasks}

\item{\code{log}}{Data frame task log of the workers.}

\item{\code{until_collect}}{Numeric of length 1, time point when
throttled task collection unlocks.}

\item{\code{until_scale}}{Numeric of length 1, time point when
throttled auto-scaling unlocks.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_controller-new}{\code{crew_class_controller$new()}}
\item \href{#method-crew_class_controller-validate}{\code{crew_class_controller$validate()}}
\item \href{#method-crew_class_controller-empty}{\code{crew_class_controller$empty()}}
\item \href{#method-crew_class_controller-saturated}{\code{crew_class_controller$saturated()}}
\item \href{#method-crew_class_controller-start}{\code{crew_class_controller$start()}}
\item \href{#method-crew_class_controller-launch}{\code{crew_class_controller$launch()}}
\item \href{#method-crew_class_controller-scale}{\code{crew_class_controller$scale()}}
\item \href{#method-crew_class_controller-push}{\code{crew_class_controller$push()}}
\item \href{#method-crew_class_controller-collect}{\code{crew_class_controller$collect()}}
\item \href{#method-crew_class_controller-pop}{\code{crew_class_controller$pop()}}
\item \href{#method-crew_class_controller-wait}{\code{crew_class_controller$wait()}}
\item \href{#method-crew_class_controller-summary}{\code{crew_class_controller$summary()}}
\item \href{#method-crew_class_controller-terminate}{\code{crew_class_controller$terminate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-new}{}}}
\subsection{Method \code{new()}}{
\code{mirai} controller constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$new(router = NULL, launcher = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{router}}{Router object. See \code{\link[=crew_controller]{crew_controller()}}.}

\item{\code{launcher}}{Launcher object. See \code{\link[=crew_controller]{crew_controller()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the controller object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
router <- crew_router()
launcher <- crew_launcher_local()
controller <- crew_controller(router = router, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the router.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-empty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-empty}{}}}
\subsection{Method \code{empty()}}{
Check if the controller is empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$empty(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is empty if it has no running tasks
or completed tasks waiting to be retrieved with \code{push()}.
}

\subsection{Returns}{
\code{TRUE} if the controller is empty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-saturated"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-saturated}{}}}
\subsection{Method \code{saturated()}}{
Check if the controller is saturated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$saturated(
  collect = TRUE,
  throttle = TRUE,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collect}}{Logical of length 1, whether to collect the results
of any newly resolved tasks before determining saturation.}

\item{\code{throttle}}{Logical of length 1, whether to delay task collection
until the next request at least \code{self$router$seconds_interval}
seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controller}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is saturated if the number of unresolved tasks
is greater than or equal to the maximum number of workers.
In other words, in a saturated controller, every available worker
has a task.
You can still push tasks to a saturated controller, but
tools that use \code{crew} such as \code{targets} may choose not to.
}

\subsection{Returns}{
\code{TRUE} if the controller is saturated, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-start}{}}}
\subsection{Method \code{start()}}{
Start the controller if it is not already started.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$start(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Register the mirai client and register worker websockets
with the launcher.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-launch}{}}}
\subsection{Method \code{launch()}}{
Launch one or more workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$launch(n = 1L, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of workers to try to launch. The actual
number launched is capped so that no more than "\code{workers}"
workers running at a given time, where "\code{workers}"
is an argument of \code{\link[=crew_controller]{crew_controller()}}. The
actual cap is the "\code{workers}" argument minus the number of connected
workers minus the number of starting workers. A "connected"
worker has an active websocket connection to the \code{mirai} client,
and "starting" means that the worker was launched at most
\code{seconds_start} seconds ago, where \code{seconds_start} is
also an argument of \code{\link[=crew_controller]{crew_controller()}}.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-scale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-scale}{}}}
\subsection{Method \code{scale()}}{
Run auto-scaling.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$scale(throttle = FALSE, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{Logical of length 1, whether to delay auto-scaling
until the next auto-scaling request at least
\code{self$router$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Methods \code{push()}, \code{pop()}, and \code{wait()} already invoke
\code{scale()} if the \code{scale} argument is \code{TRUE}.
If you call \code{scale()} manually, it is recommended to call \code{collect()}
first so \code{scale()} can accurately assess the task load.
For finer control of the number of workers launched,
call \code{launch()} on the controller with the exact desired
number of workers.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-push"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-push}{}}}
\subsection{Method \code{push()}}{
Push a task to the head of the task list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$push(
  command,
  data = list(),
  globals = list(),
  substitute = TRUE,
  seed = sample.int(n = 1000000000L, size = 1L),
  packages = character(0),
  library = NULL,
  seconds_timeout = NULL,
  scale = TRUE,
  throttle = TRUE,
  name = NULL,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{data}}{Named list of local data objects in the
evaluation environment.}

\item{\code{globals}}{Named list of objects to temporarily assign to the
global environment for the task. See the \code{reset_globals} argument
of \code{\link[=crew_controller_local]{crew_controller_local()}}.}

\item{\code{substitute}}{Logical of length 1, whether to call
\code{base::substitute()} on the supplied value of the
\code{command} argument. If \code{TRUE} (default) then \code{command} is quoted
literally as you write it, e.g.
\code{push(command = your_function_call())}. If \code{FALSE}, then \code{crew}
assumes \code{command} is a language object and you are passing its
value, e.g. \code{push(command = quote(your_function_call()))}.
\code{substitute = TRUE} is appropriate for interactive use,
whereas \code{substitute = FALSE} is meant for automated R programs
that invoke \code{crew} controllers.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to temporarily set for the evaluation of the task.
At the end of the task, the seed is restored.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{scale}}{Logical, whether to automatically call \code{scale()}
to auto-scale workers to meet the demand of the task load.
By design, auto-scaling might not actually happen
if \code{throttle = TRUE}.
If \code{scale} is \code{TRUE}, then \code{collect()} runs first
so demand can be properly assessed before scaling and the number
of workers is not too high.}

\item{\code{throttle}}{If \code{scale} is \code{TRUE}, whether to defer auto-scaling
until the next request at least
\code{self$router$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{name}}{Optional name of the task. Replaced with a random name
if \code{NULL} or in conflict with an existing name in the task list.}

\item{\code{controller}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-collect"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-collect}{}}}
\subsection{Method \code{collect()}}{
Check for done tasks and move the results to
the results list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$collect(throttle = FALSE, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{whether to defer task collection
until the next task collection request at least
\code{self$router$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly). Removes elements from the \code{queue}
list as applicable and moves them to the \code{results} list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-pop"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-pop}{}}}
\subsection{Method \code{pop()}}{
Pop a completed task from the results data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$pop(
  scale = TRUE,
  collect = TRUE,
  throttle = TRUE,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{Logical of length 1,
whether to automatically call \code{scale()}
to auto-scale workers to meet the demand of the task load.
Auto-scaling might not actually happen if \code{throttle} is \code{TRUE}.
If \code{TRUE}, then \code{collect()} runs first
so demand can be properly assessed before scaling and the number
of workers is not too high. Scaling up on \code{pop()} may be important
for transient or nearly transient workers that tend to drop off
quickly after doing little work.}

\item{\code{collect}}{Logical of length 1. If \code{scale} is \code{FALSE},
whether to call \code{collect()}
to pick up the results of completed tasks. This task collection
step always happens (with throttling) when \code{scale} is \code{TRUE}.}

\item{\code{throttle}}{Whether to defer auto-scaling and task collection
until the next request at least
\code{self$router$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If not task is currently completed and collected, \code{pop()}
will attempt to auto-scale workers as needed and collect
any newly completed results.
}

\subsection{Returns}{
If there is a completed task available to collect, the return
value is a one-row data frame with the results, warnings, and errors.
Otherwise, if there are no results available to collect,
the return value is \code{NULL}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-wait"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-wait}{}}}
\subsection{Method \code{wait()}}{
Wait for tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$wait(
  mode = "all",
  seconds_interval = 0.01,
  seconds_timeout = Inf,
  scale = TRUE,
  throttle = TRUE,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{If \code{mode} is \code{"all"},
then the method waits for all tasks to complete. If \code{mode} is
\code{"one"}, then it waits until a one task is complete.}

\item{\code{seconds_interval}}{Number of seconds to wait between polling
intervals waiting for tasks.}

\item{\code{seconds_timeout}}{Timeout length in seconds waiting for tasks.}

\item{\code{scale}}{Logical, whether to automatically call \code{scale()}
to auto-scale workers to meet the demand of the task load.
Might not actually auto-scale on every iteration if \code{throttle}
is \code{TRUE}.}

\item{\code{throttle}}{Whether to defer auto-scaling
and task collection until the next request at least
\code{self$router$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.
Highly recommended
to keep \code{throttle = TRUE} in \code{wait()} to ensure efficiency
and robustness.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{wait()} method blocks the calling R session,
repeatedly auto-scales workers for tasks
that need them, and repeatedly collects results.
The function runs until it either times out or reaches
its stopping condition based on the \code{mode} argument.
}

\subsection{Returns}{
\code{NULL} (invisibly). Call \code{pop()} to get the result.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-summary"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-summary}{}}}
\subsection{Method \code{summary()}}{
Summarize the workers and tasks of the controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$summary(
  columns = tidyselect::everything(),
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{columns}}{Tidyselect expression to select a subset of columns.
Examples include \code{columns = contains("worker")} and
\code{columns = starts_with("tasks")}.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame of summary statistics on the workers and tasks.
It has one row per worker websocket and the following columns:
\itemize{
\item \code{controller}: name of the controller.
\item \code{popped_tasks}: number of tasks which were completed by
a worker at the websocket and then returned by calling
\code{pop()} on the controller object.
\item \code{popped_seconds}: total number of runtime and seconds of
all the tasks that ran on a worker connected to this websocket
and then were retrieved by calling \code{pop()} on the controller
object.
\item \code{popped_errors}: total number of tasks which ran on a worker
at the website, encountered an error in R, and then retrieved
with \code{pop()}.
\item \code{popped_warnings}: total number of tasks which ran on a worker
at the website, encountered one or more warnings in R,
and then retrieved with \code{pop()}. Note: \code{popped_warnings}
is actually the number of \emph{tasks}, not the number of warnings.
(A task could throw more than one warning.)
\item \code{tasks_assigned}: number of pushed tasks assigned to the
current worker process at the websocket. The counter resets
every time a new worker instance starts.
So in the case of transient
workers, this number may be much smaller than the number of
popped tasks.
\item \code{tasks_complete}: number of pushed tasks completed by the
current worker process at the websocket. The counter resets
every time a new worker instance starts.
So in the case of transient
workers, this number may be much smaller than the number of
popped tasks.
\item \code{worker_index}: Numeric index of the worker within the controller.
\item \code{worker_connected}: \code{TRUE} if a worker is currently connected
to the websocket, \code{FALSE} if not connected, or \code{NA}
if the status cannot be determined because the \code{mirai}
client is not running.
\item \code{worker_launches}: number of attempts to launch a worker
at the websocket since the controller started. If
the number of launch attempts gets much higher than
the number of popped tasks or worker instances, then this is a
sign that something is wrong with the workers or platform,
and it is recommended to quit the pipeline and troubleshoot.
\item \code{worker_instances}: number of different worker processes
that have connected to the websocket since the \code{start()}
of the controller object. Should either be 0 or 1 unless
something is wrong and more than one worker has connected
to the current websocket.
\item \code{worker_socket} full websocket address of the worker, including
the protocol, IP address, TCP port, and path.
This websocket rotates with every additional instance
of a worker process.
To identify specific pieces of the websocket address,
call \code{nanonext::parse_url()}.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate the workers and the \code{mirai} client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$terminate(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
