% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_monitor_aws_batch.R
\name{crew_class_monitor_aws_batch}
\alias{crew_class_monitor_aws_batch}
\title{AWS Batch monitor class}
\description{
AWS Batch monitor \code{R6} class
}
\details{
See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.
}
\section{IAM policies}{

In order for the AWS Batch \code{crew} monitor class to function
properly, your IAM policy needs permission to perform the \code{SubmitJob},
\code{TerminateJob}, \code{ListJobs}, and \code{DescribeJobs} AWS Batch API calls.
In addition, to download CloudWatch logs with the \code{log()} method,
your IAM policy also needs permission to perform the \code{GetLogEvents}
CloudWatch logs API call.
For more information on AWS policies and permissions, please visit
\url{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html}.
}

\seealso{
Other monitor: 
\code{\link{crew_monitor_aws_batch}()}
}
\concept{monitor}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{job_queue}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{job_definition}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{log_group}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{config}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{credentials}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{endpoint}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{region}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_monitor_aws_batch-new}{\code{crew_class_monitor_aws_batch$new()}}
\item \href{#method-crew_class_monitor_aws_batch-validate}{\code{crew_class_monitor_aws_batch$validate()}}
\item \href{#method-crew_class_monitor_aws_batch-terminate}{\code{crew_class_monitor_aws_batch$terminate()}}
\item \href{#method-crew_class_monitor_aws_batch-status}{\code{crew_class_monitor_aws_batch$status()}}
\item \href{#method-crew_class_monitor_aws_batch-log}{\code{crew_class_monitor_aws_batch$log()}}
\item \href{#method-crew_class_monitor_aws_batch-jobs}{\code{crew_class_monitor_aws_batch$jobs()}}
\item \href{#method-crew_class_monitor_aws_batch-active}{\code{crew_class_monitor_aws_batch$active()}}
\item \href{#method-crew_class_monitor_aws_batch-inactive}{\code{crew_class_monitor_aws_batch$inactive()}}
\item \href{#method-crew_class_monitor_aws_batch-submitted}{\code{crew_class_monitor_aws_batch$submitted()}}
\item \href{#method-crew_class_monitor_aws_batch-pending}{\code{crew_class_monitor_aws_batch$pending()}}
\item \href{#method-crew_class_monitor_aws_batch-runnable}{\code{crew_class_monitor_aws_batch$runnable()}}
\item \href{#method-crew_class_monitor_aws_batch-starting}{\code{crew_class_monitor_aws_batch$starting()}}
\item \href{#method-crew_class_monitor_aws_batch-running}{\code{crew_class_monitor_aws_batch$running()}}
\item \href{#method-crew_class_monitor_aws_batch-succeeded}{\code{crew_class_monitor_aws_batch$succeeded()}}
\item \href{#method-crew_class_monitor_aws_batch-failed}{\code{crew_class_monitor_aws_batch$failed()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-new}{}}}
\subsection{Method \code{new()}}{
AWS Batch job definition constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$new(
  job_queue = NULL,
  job_definition = NULL,
  log_group = NULL,
  config = NULL,
  credentials = NULL,
  endpoint = NULL,
  region = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_queue}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{job_definition}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{log_group}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{config}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{credentials}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{endpoint}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}

\item{\code{region}}{See \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
AWS Batch job definition object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly). Throws an error if a field is invalid.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate one or more AWS Batch jobs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$terminate(
  ids = NULL,
  all = FALSE,
  reason = "cancelled/terminated by crew.aws.batch monitor",
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{Character vector with the IDs of the AWS Batch jobs
to terminate. Leave as \code{NULL} if \code{all} is \code{TRUE}.}

\item{\code{all}}{\code{TRUE} to terminate all jobs belonging to
the previously specified job definition. \code{FALSE} to terminate
only the job IDs given in the \code{ids} argument.}

\item{\code{reason}}{Character of length 1, natural language explaining
the reason the job was terminated.}

\item{\code{verbose}}{Logical of length 1, whether to show a progress bar
if the R process is interactive and \code{length(ids)} is greater than 1.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-status"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-status}{}}}
\subsection{Method \code{status()}}{
Get the status of a single job
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$status(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Character of length 1, job ID. This is different
from the user-supplied job name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A one-row \code{tibble} with information about the job.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-log"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-log}{}}}
\subsection{Method \code{log()}}{
Get the CloudWatch log of a job.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$log(id, start_from_head = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Character of length 1, job ID. This is different
from the user-supplied job name.}

\item{\code{start_from_head}}{Logical of length 1, whether to print earlier
log events before later ones.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method assumes the job has log driver \code{"awslogs"}
(specifying AWS CloudWatch) and that the log group is the one
prespecified in the \code{log_group} argument of
\code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}. This method cannot use
other log drivers such as Splunk, and it will fail if the log
group is wrong or missing.
}

\subsection{Returns}{
A \code{tibble} with log information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-jobs"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-jobs}{}}}
\subsection{Method \code{jobs()}}{
List all the jobs in the given job queue
with the given job definition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$jobs(
  status = c("submitted", "pending", "runnable", "starting", "running", "succeeded",
    "failed")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{Character vector of job states. Results are limited
to these job states.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-active"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-active}{}}}
\subsection{Method \code{active()}}{
List active jobs: submitted, pending,
runnable, starting, or running (not succeeded or failed).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$active()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-inactive"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-inactive}{}}}
\subsection{Method \code{inactive()}}{
List inactive jobs: ones whose status
is succeeded or failed (not submitted, pending,
runnable, starting, or running).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$inactive()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-submitted"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-submitted}{}}}
\subsection{Method \code{submitted()}}{
List jobs whose status is \code{"submitted"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$submitted()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-pending"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-pending}{}}}
\subsection{Method \code{pending()}}{
List jobs whose status is \code{"pending"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$pending()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-runnable"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-runnable}{}}}
\subsection{Method \code{runnable()}}{
List jobs whose status is \code{"runnable"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$runnable()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-starting"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-starting}{}}}
\subsection{Method \code{starting()}}{
List jobs whose status is \code{"starting"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$starting()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-running"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-running}{}}}
\subsection{Method \code{running()}}{
List jobs whose status is \code{"running"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$running()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-succeeded"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-succeeded}{}}}
\subsection{Method \code{succeeded()}}{
List jobs whose status is \code{"succeeded"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$succeeded()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_monitor_aws_batch-failed"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_monitor_aws_batch-failed}{}}}
\subsection{Method \code{failed()}}{
List jobs whose status is \code{"failed"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_monitor_aws_batch$failed()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The output only includes jobs under the
job queue and job definition
that were supplied through \code{\link[=crew_monitor_aws_batch]{crew_monitor_aws_batch()}}.
}

\subsection{Returns}{
A \code{tibble} with one row per job and columns
with job information.
}
}
}
