% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_definition_aws_batch.R
\name{crew_class_definition_aws_batch}
\alias{crew_class_definition_aws_batch}
\title{AWS Batch definition class}
\description{
AWS Batch definition \code{R6} class
}
\details{
See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.
}
\section{IAM policies}{

In order for the AWS Batch \code{crew} job definition class to function
properly, your IAM policy needs permission to perform the
\code{RegisterJobDefinition}, \code{DeregisterJobDefinition}, and
\code{DescribeJobDefinitions} AWS Batch API calls.
For more information on AWS policies and permissions, please visit
\url{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html}.
}

\seealso{
Other definition: 
\code{\link{crew_definition_aws_batch}()}
}
\concept{definition}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{job_queue}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{job_definition}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{log_group}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{config}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{credentials}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{endpoint}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{region}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_definition_aws_batch-new}{\code{crew_class_definition_aws_batch$new()}}
\item \href{#method-crew_class_definition_aws_batch-validate}{\code{crew_class_definition_aws_batch$validate()}}
\item \href{#method-crew_class_definition_aws_batch-register}{\code{crew_class_definition_aws_batch$register()}}
\item \href{#method-crew_class_definition_aws_batch-deregister}{\code{crew_class_definition_aws_batch$deregister()}}
\item \href{#method-crew_class_definition_aws_batch-describe}{\code{crew_class_definition_aws_batch$describe()}}
\item \href{#method-crew_class_definition_aws_batch-submit}{\code{crew_class_definition_aws_batch$submit()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_definition_aws_batch-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_definition_aws_batch-new}{}}}
\subsection{Method \code{new()}}{
AWS Batch job definition constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_definition_aws_batch$new(
  job_queue = NULL,
  job_definition = NULL,
  log_group = NULL,
  config = NULL,
  credentials = NULL,
  endpoint = NULL,
  region = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_queue}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{job_definition}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{log_group}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{config}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{credentials}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{endpoint}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}

\item{\code{region}}{See \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
AWS Batch job definition object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_definition_aws_batch-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_definition_aws_batch-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_definition_aws_batch$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly). Throws an error if a field is invalid.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_definition_aws_batch-register"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_definition_aws_batch-register}{}}}
\subsection{Method \code{register()}}{
Register a job definition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_definition_aws_batch$register(
  image,
  platform_capabilities = "EC2",
  memory_units = "gigabytes",
  memory = NULL,
  cpus = NULL,
  gpus = NULL,
  seconds_timeout = NULL,
  scheduling_priority = NULL,
  tags = NULL,
  propagate_tags = NULL,
  parameters = NULL,
  job_role_arn = NULL,
  execution_role_arn = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{image}}{Character of length 1, Docker image used for each job.
You can supply a path to an image in Docker Hub or the full URI
of an image in an Amazon ECR repository.}

\item{\code{platform_capabilities}}{Optional character of length 1, either
\code{"EC2"} to run on EC2 or \code{"FARGATE"} to run on Fargate.}

\item{\code{memory_units}}{Character of length 1,
either \code{"gigabytes"} or \code{"mebibytes"} to set the units of the
\code{memory} argument. \code{"gigabytes"} is simpler for EC2 jobs, but
Fargate has strict requirements about specifying exact amounts of
mebibytes (MiB). for details, read
\url{https://docs.aws.amazon.com/cli/latest/reference/batch/register-job-definition.html} # nolint}

\item{\code{memory}}{Positive numeric of length 1, amount of memory to request
for each job.}

\item{\code{cpus}}{Positive numeric of length 1, number of virtual
CPUs to request for each job.}

\item{\code{gpus}}{Positive numeric of length 1, number of GPUs to
request for each job.}

\item{\code{seconds_timeout}}{Optional positive numeric of length 1,
number of seconds until a job times out.}

\item{\code{scheduling_priority}}{Optional nonnegative integer of length 1
between \code{0} and \code{9999}, priority of jobs. Jobs with higher-valued
priorities are scheduled first.
The priority only applies if the job queue has a fair share
policy. Set to \code{NULL} to omit.}

\item{\code{tags}}{Optional character vector of tags.}

\item{\code{propagate_tags}}{Optional logical of length 1, whether to propagate
tags from the job or definition to the ECS task.}

\item{\code{parameters}}{Optional character vector of key-value pairs
designating parameters for job submission.}

\item{\code{job_role_arn}}{Character of length 1,
Amazon resource name (ARN) of the job role.}

\item{\code{execution_role_arn}}{Character of length 1,
Amazon resource name (ARN) of the execution role.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{register()} method registers a simple
job definition using the job definition name and log group originally
supplied to \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.
Job definitions created with \verb{$register()} are container-based
and use the AWS log driver.
For more complicated
kinds of jobs, we recommend skipping \code{register()}: first call
\url{https://www.paws-r-sdk.com/docs/batch_register_job_definition/}
to register the job definition, then supply the job definition
name to the \code{job_definition} argument of \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.
}

\subsection{Returns}{
A one-row \code{tibble} with the job definition name, ARN, and
revision number of the registered job definition.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_definition_aws_batch-deregister"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_definition_aws_batch-deregister}{}}}
\subsection{Method \code{deregister()}}{
Attempt to deregister a revision of the job definition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_definition_aws_batch$deregister(revision = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{revision}}{Finite positive integer of length 1, optional revision
number to deregister. If \code{NULL}, then only the highest revision
number of the job definition is deregistered, if it exists.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Attempt to deregister the job definition whose name was
originally supplied to the \code{job_definition} argument of
\code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_definition_aws_batch-describe"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_definition_aws_batch-describe}{}}}
\subsection{Method \code{describe()}}{
Describe the revisions of the job definition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_definition_aws_batch$describe(revision = NULL, active = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{revision}}{Positive integer of length 1, optional revision
number to describe.}

\item{\code{active}}{Logical of length 1, whether to filter on just
the active job definition.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{tibble} with job definition information.
There is one row per revision.
Some fields may be nested lists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_definition_aws_batch-submit"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_definition_aws_batch-submit}{}}}
\subsection{Method \code{submit()}}{
Submit an AWS Batch job with the given job definition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_definition_aws_batch$submit(
  command = c("sleep", "300"),
  name = paste0("crew-aws-batch-job-", crew::crew_random_name()),
  memory_units = "gigabytes",
  memory = NULL,
  cpus = NULL,
  gpus = NULL,
  seconds_timeout = NULL,
  share_identifier = NULL,
  scheduling_priority_override = NULL,
  tags = NULL,
  propagate_tags = NULL,
  parameters = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Character vector with the command
to submit for the job. Usually a Linux shell command
with each term in its own character string.}

\item{\code{name}}{Character of length 1 with the job name.}

\item{\code{memory_units}}{Character of length 1,
either \code{"gigabytes"} or \code{"mebibytes"} to set the units of the
\code{memory} argument. \code{"gigabytes"} is simpler for EC2 jobs, but
Fargate has strict requirements about specifying exact amounts of
mebibytes (MiB). for details, read
\url{https://docs.aws.amazon.com/cli/latest/reference/batch/register-job-definition.html} # nolint}

\item{\code{memory}}{Positive numeric of length 1, amount of memory to request
for each job.}

\item{\code{cpus}}{Positive numeric of length 1, number of virtual
CPUs to request for each job.}

\item{\code{gpus}}{Positive numeric of length 1, number of GPUs to
request for each job.}

\item{\code{seconds_timeout}}{Optional positive numeric of length 1,
number of seconds until a job times out.}

\item{\code{share_identifier}}{Character of length 1 with the share
identifier of the job. Only applies if the job queue has a
scheduling policy. Read the official AWS Batch documentation
for details.}

\item{\code{scheduling_priority_override}}{Optional nonnegative integer
of length between \code{0} and \code{9999}, priority of the job.
This value overrides the priority in the job definition.
Jobs with higher-valued priorities are scheduled first.
The priority applies if the job queue has a fair share policy.
Set to \code{NULL} to omit.}

\item{\code{tags}}{Optional character vector of tags.}

\item{\code{propagate_tags}}{Optional logical of length 1, whether to propagate
tags from the job or definition to the ECS task.}

\item{\code{parameters}}{Optional character vector of key-value pairs
designating parameters for job submission.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method uses the job queue and job definition
that were supplied through \code{\link[=crew_definition_aws_batch]{crew_definition_aws_batch()}}.
Any jobs submitted this way are different from the
\code{crew} workers that the \code{crew} controller starts automatically
using the AWS Batch launcher plugin.
You may use the \code{submit()} method in the definition for different
purposes such as testing.
}

\subsection{Returns}{
A one-row \code{tibble} with the name, ID, and
Amazon resource name (ARN) of the job.
}
}
}
