% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crest.get_modern_data.R
\name{crest.get_modern_data}
\alias{crest.get_modern_data}
\title{Extract distributions from the database}
\usage{
crest.get_modern_data(
  pse,
  taxaType,
  climate,
  df = NA,
  ai.sqrt = FALSE,
  xmn = NA,
  xmx = NA,
  ymn = NA,
  ymx = NA,
  continents = NA,
  countries = NA,
  basins = NA,
  sectors = NA,
  realms = NA,
  biomes = NA,
  ecoregions = NA,
  minGridCells = 20,
  elev_min = NA,
  elev_max = NA,
  elev_range = NA,
  year_min = 1900,
  year_max = 2021,
  nodate = TRUE,
  type_of_obs = c(1, 2, 3, 8, 9),
  selectedTaxa = NA,
  site_info = c(NA, NA),
  site_name = NA,
  dbname = "gbif4crest_02",
  verbose = TRUE
)
}
\arguments{
\item{pse}{A pollen-Species equivalency table. See \code{\link{createPSE}} for
details.}

\item{taxaType}{A numerical index (between 1 and 6) to define the type of
palaeoproxy used: 1 for plants, 2 for beetles, 3 for chironomids,
4 for foraminifers, 5 for diatoms and 6 for rodents. The example
dataset uses taxaType=0 (pseudo-data). Default is 1.}

\item{climate}{A vector of the climate variables to extract. See
\code{\link{accClimateVariables}} for the list of accepted values.}

\item{df}{A data frame containing the data to reconstruct (counts,
percentages or presence/absence data).}

\item{ai.sqrt}{A boolean to indicate whether ai values should be square-root
transformed (default \code{FALSE}).}

\item{xmn}{The coordinates defining the study area.}

\item{xmx}{The coordinates defining the study area.}

\item{ymn}{The coordinates defining the study area.}

\item{ymx}{The coordinates defining the study area.}

\item{continents}{A vector of the continent names defining the study area.}

\item{countries}{A vector of the country names defining the study area.}

\item{basins}{A vector of the ocean names defining the study area.}

\item{sectors}{A vector of the marine sector names defining the study area.}

\item{realms}{A vector of the studied botanical realms defining the study area.}

\item{biomes}{A vector of the studied botanical biomes defining the study area.}

\item{ecoregions}{A vector of the studied botanical ecoregions defining the
study area.}

\item{minGridCells}{The minimum number of unique presence data necessary to
estimate a species' climate response. Default is 20.}

\item{elev_min}{Parameters to only selected grid cells with an
elevation higher than elev_min or lower than elev_max (default is
'\code{NA} ).}

\item{elev_max}{Parameters to only selected grid cells with an
elevation higher than elev_min or lower than elev_max (default is
'\code{NA} ).}

\item{elev_range}{Parameters discard the grid cell with a high elevation
range (default is \code{NA}).}

\item{year_min}{The oldest and youngest occurrences accepted
(default is 1900-2021).}

\item{year_max}{The oldest and youngest occurrences accepted
(default is 1900-2021).}

\item{nodate}{A boolean to accept occurrences without a date (can overlap
with occurrences with a date; default \code{TRUE}).}

\item{type_of_obs}{The type of observation to use in the study. 1: human
observation, 2: observation, 3: preserved specimen, 4: living specimen,
5: fossil specimen, 6: material sample, 7: machine observation, 8:
literature, 9: unknown (Default \code{c(1, 2, 3, 8, 9)})}

\item{selectedTaxa}{A data frame assigns which taxa should be used for each
variable (1 if the taxon should be used, 0 otherwise). The colnames
should be the climate variables' names and the rownames the taxa
names. Default is 1 for all taxa and all variables.}

\item{site_info}{A vector containing the coordinates of the study site.
Default \code{c(NA, NA)}.}

\item{site_name}{The name of the dataset (default \code{NA}).}

\item{dbname}{The name of the database. Default is \code{'gbif4crest_02'}.}

\item{verbose}{A boolean to print non-essential comments on the terminal
(default \code{TRUE}).}
}
\value{
A \code{\link{crestObj}} object containing the spatial distributions.
}
\description{
This function will extract the distributions of all the species composing each
taxon and return them as a list.
}
\examples{
\dontrun{
  data(crest_ex_pse)
  data(crest_ex_selection)
  data(crest_ex)
  x <- crest.get_modern_data( df = crest_ex,
    pse = crest_ex_pse, taxaType = 0,
    climate = c("bio1", "bio12"),
    selectedTaxa = crest_ex_selection, dbname = "crest_example",
    verbose = FALSE
  )
  x
  lapply(x$modelling$distributions, head)
}

}
