% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbFixedNames.R
\name{accClimateVariables}
\alias{accClimateVariables}
\title{Describes all the variables available in the database.}
\usage{
accClimateVariables(v = NA, domain = NA)
}
\arguments{
\item{v}{The name of a variable to quickly access its description and ID
(default \code{NA} returns all possible values).}

\item{domain}{The domain ('Terrestrial' or 'Marine') of the variables.
Default value is \cite{NA} and both terrestrial and marine climate
variable names are returned.}
}
\value{
A data frame descriptive of the climate variables available in the
database (if \code{v=NA}) or the description of variable v.
}
\description{
Provides the index and the short and full names of all the variables
available in the database.
}
\examples{
\dontrun{
  accClimateVariables()
  accClimateVariables(v='bio12')
}

}
\seealso{
\url{https://www.worldclim.org/data/bioclim.html} for details on the 'bio' data, \url{https://cgiarcsi.community/2019/01/24/global-aridity-index-and-potential-evapotranspiration-climate-database-v2/} for details on 'ai', \url{https://www.ncei.noaa.gov/products/world-ocean-atlas} for details on the sea surface temperature, sea surface salinity and nutrient Concentration data, or \url{https://psl.noaa.gov/data/gridded/data.noaa.oisst.v2.highres.html} for the sea ice concentration data.
}
