% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_training.R
\name{training_model}
\alias{training_model}
\title{Training model}
\usage{
training_model(model_name = "mymodel", dat, dat_test = NULL,
  target = NULL, occur_time = NULL, obs_id = NULL, x_list = NULL,
  ex_cols = NULL, pos_flag = NULL, prop = 0.7, preproc = TRUE,
  one_hot = FALSE, miss_values = NULL, outlier_proc = TRUE,
  missing_proc = TRUE, feature_filter = list(filter = c("IV", "PSI",
  "COR", "XGB"), iv_cp = 0.02, psi_cp = 0.1, xgb_cp = 0, cv_folds = 1,
  hopper = FALSE), algorithm = list("LR", "XGB", "GBM", "RF"),
  LR.params = lr_params(), XGB.params = xgb_params(),
  GBM.params = gbm_params(), RF.params = rf_params(),
  breaks_list = NULL, parallel = FALSE, cores_num = NULL,
  save_pmml = FALSE, plot_show = FALSE, vars_plot = TRUE,
  model_path = tempdir(), seed = 46, ...)
}
\arguments{
\item{model_name}{A string, name of the project. Default is "mymodel"}

\item{dat}{A data.frame with independent variables and target variable.}

\item{dat_test}{A data.frame of test data. Default is NULL.}

\item{target}{The name of target variable.}

\item{occur_time}{The name of the variable that represents the time at which each observation takes place.Default is NULL.}

\item{obs_id}{The name of ID of observations or key variable of data. Default is NULL.}

\item{x_list}{Names of independent variables. Default is NULL.}

\item{ex_cols}{Names of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{pos_flag}{The value of positive class of target variable, default: "1".}

\item{prop}{Percentage of train-data after the partition. Default: 0.7.}

\item{preproc}{Logical. Preprocess data. Default is TRUE}

\item{one_hot}{Logical. If TRUE, one-hot_encoding  of category variables. Default is FASLE.}

\item{miss_values}{Other extreme value might be used to represent missing values, e.g: -9999, -9998. These miss_values will be encoded to -1 or "Missing".}

\item{outlier_proc}{Logical. If TRUE,  Outliers processing using Kmeans and Local Outlier Factor. Default is TRUE}

\item{missing_proc}{Logical. If TRUE, missing value analysis and process missing value by knn imputation or central impulation or random imputation. Default is TRUE}

\item{feature_filter}{Parameters for selecting important and stable features.See details at: \code{\link{feature_select_wrapper}}}

\item{algorithm}{Algorithms for training a model. list("LR", "XGB", "GBDT", "RF") are available.}

\item{LR.params}{Parameters of logistic regression & scorecard. See details at :  \code{\link{lr_params}}.}

\item{XGB.params}{Parameters of xgboost. See details at :  \code{\link{xgb_params}}.}

\item{GBM.params}{Parameters of GBM. See details at :  \code{\link{gbm_params}}.}

\item{RF.params}{Parameters of Random Forest. See details at :  \code{\link{rf_params}}.}

\item{breaks_list}{A table containing a list of splitting points for each independent variable. Default is NULL.}

\item{parallel}{Default is FALSE}

\item{cores_num}{The number of CPU cores to use.}

\item{save_pmml}{Logical, save model in PMML format. Default is TRUE.}

\item{plot_show}{Logical, show model performance in current graphic device. Default is FALSE.}

\item{vars_plot}{Logical, if TRUE, plot distribution ,correlation or partial dependence of model input variables . Default is TRUE.}

\item{model_path}{The path for periodically saved data file. Default is \code{tempdir()}.}

\item{seed}{Random number seed. Default is 46.}

\item{...}{Other parameters.}
}
\value{
A list containing Model Objects.
}
\description{
\code{training_model} Model builder
}
\examples{
sub = cv_split(UCICreditCard, k = 60)[[1]]
dat = UCICreditCard[sub,]
dat = re_name(dat, "default.payment.next.month", "target")
dat = data_cleansing(dat, target = "target", obs_id = "ID",
occur_time = "apply_date", miss_values = list("", -1, -2))
train_test <- train_test_split(dat, split_type = "OOT", prop = 0.7,
                                occur_time = "apply_date")
dat_train = train_test$train
dat_test = train_test$test
x_list = c("PAY_0", "LIMIT_BAL", "PAY_AMT5")
B_model = training_model(dat = dat_train,
model_name = "UCICreditCard", target = "target", x_list = x_list,
occur_time = "apply_date", obs_id = "ID", dat_test = dat_test,
                           preproc = FALSE,
                           feature_filter = NULL,
                           algorithm = list("LR"),
                           LR.params = lr_params(lasso = FALSE,
                           step_wise = FALSE),
                           breaks_list = NULL,
                           parallel = FALSE, cores_num = NULL,
                           save_pmml = FALSE, plot_show = FALSE,
                           vars_plot = FALSE,
                           model_path = tempdir(),
                           seed = 46)
}
\seealso{
\code{\link{train_test_split}},\code{\link{data_cleansing}}, \code{\link{feature_select_wrapper}},   \code{\link{lr_params}}, \code{\link{xgb_params}}, \code{\link{gbm_params}}, \code{\link{rf_params}},\code{\link{fast_high_cor_filter}},\code{\link{get_breaks_all}},\code{\link{lasso_filter}}, \code{\link{woe_trans_all}}, \code{\link{get_logistic_coef}}, \code{\link{score_transfer}},\code{\link{get_score_card}}, \code{\link{model_key_index}},\code{\link{ks_psi_plot}},\code{\link{get_plots}},\code{\link{ks_table_plot}}
}
