% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_isochrone.R
\name{get_isochrone}
\alias{get_isochrone}
\title{Compute isochrones/isodistances from nodes.}
\usage{
get_isochrone(Graph, from, lim, setdif = FALSE)
}
\arguments{
\item{Graph}{An object generated by cppRouting::makegraph() function.}

\item{from}{numeric or character. A vector of one or more vertices from which isochrones/isodistances are calculated.}

\item{lim}{numeric. A vector of one or multiple breaks.}

\item{setdif}{logical. If TRUE and length(lim)>1, nodes that are reachable in a given break will not appear in a greater one.}
}
\value{
List containing reachable nodes below cost limit(s).
}
\description{
Compute isochrones/isodistances from nodes.
}
\details{
If length(lim)>1, value is a list of length(from), containing lists of length(lim)
}
\note{
get_isochrone() recursively perform Dijkstra algorithm for each 'from' nodes and stop when cost limit is reached.
}
\examples{
#Data describing edges of the graph
edges<-data.frame(from_vertex=c(0,0,1,1,2,2,3,4,4), 
                  to_vertex=c(1,3,2,4,4,5,1,3,5), 
                  cost=c(9,2,11,3,5,12,4,1,6))
                  
#Construct directed graph 
directed_graph<-makegraph(edges,directed=TRUE)

#Get nodes reachable around node 4 with maximum distances of 1 and 2
iso<-get_isochrone(Graph=directed_graph,from = "4",lim=c(1,2))

#With setdif set to TRUE
iso2<-get_isochrone(Graph=directed_graph,from = "4",lim=c(1,2),setdif=TRUE)
print(iso)
print(iso2)
}
