% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecov.R
\name{codecov}
\alias{codecov}
\title{Run covr on a package and upload the result to codecov.io}
\usage{
codecov(..., coverage = NULL, base_url = "https://codecov.io",
  token = NULL, commit = NULL, branch = NULL, flags = NULL,
  quiet = TRUE)
}
\arguments{
\item{...}{arguments passed to \code{\link[=package_coverage]{package_coverage()}}}

\item{coverage}{an existing coverage object to submit, if \code{NULL},
\code{\link[=package_coverage]{package_coverage()}} will be called with the arguments from
\code{...}}

\item{base_url}{Codecov url (change for Enterprise)}

\item{token}{a codecov upload token, if \code{NULL} then following external
sources will be checked in this order:
\enumerate{
\item the environment variable \sQuote{CODECOV_TOKEN}. If it is empty, then
\item package will look at directory of the package for a file \code{codecov.yml}.
File must have \code{codecov} section where field \code{token} is set to a token that
will be used.
}}

\item{commit}{explicitly set the commit this coverage result object
corresponds to. Is looked up from the service or locally if it is
\code{NULL}.}

\item{branch}{explicitly set the branch this coverage result object
corresponds to, this is looked up from the service or locally if it is
\code{NULL}.}

\item{flags}{A flag to use for this coverage upload see
\url{https://docs.codecov.io/docs/flags} for details.}

\item{quiet}{if \code{FALSE}, print the coverage before submission.}
}
\description{
Run covr on a package and upload the result to codecov.io
}
\examples{
\dontrun{
codecov(path = "test")
}
}
