% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covr.R
\name{package_coverage}
\alias{package_coverage}
\title{Calculate test coverage for a package}
\usage{
package_coverage(path = ".", type = c("tests", "vignettes", "examples",
  "all", "none"), combine_types = TRUE, relative_path = TRUE,
  quiet = TRUE, clean = TRUE, line_exclusions = NULL,
  function_exclusions = NULL, code = character(), ..., exclusions)
}
\arguments{
\item{path}{file path to the package.}

\item{type}{run the package \sQuote{tests}, \sQuote{vignettes},
\sQuote{examples}, \sQuote{all}, or \sQuote{none}. The default is
\sQuote{tests}.}

\item{combine_types}{If \code{TRUE} (the default) the coverage for all types
is simply summed into one coverage object. If \code{FALSE} separate objects
are used for each type of coverage.}

\item{relative_path}{whether to output the paths as relative or absolute
paths.}

\item{quiet}{whether to load and compile the package quietly, useful for
debugging errors.}

\item{clean}{whether to clean temporary output files after running, mainly
useful for debugging errors.}

\item{line_exclusions}{a named list of files with the lines to exclude from
each file.}

\item{function_exclusions}{a vector of regular expressions matching function
names to exclude. Example \code{print\\.} to match print methods.}

\item{code}{A character vector of additional test code to run.}

\item{...}{Additional arguments passed to \code{\link[tools]{testInstalledPackage}}.}

\item{exclusions}{\sQuote{Deprecated}, please use \sQuote{line_exclusions} instead.}
}
\description{
This function calculates the test coverage for a development package on the
\code{path}. By default it runs only the package tests, but it can also run
vignette and example code.
}
\details{
This function uses \code{\link[tools]{testInstalledPackage}} to run the
code, if you would like to test your package in another way you can set
\code{type = "none"} and pass the code to run as a character vector to the
\code{code} parameter.

#ifdef unix
Parallelized code using \pkg{parallel}'s \code{\link{mcparallel}} needs to
be use a patched \code{parallel:::mcexit}. This is done automatically if the
package depends on \pkg{parallel}, but can also be explicitly set using the
environment variable \code{COVR_FIX_PARALLEL_MCEXIT} or the global option
\code{covr.fix_parallel_mcexit}.
#endif
}
\seealso{
\code{\link{exclusions}} For details on excluding parts of the
package from the coverage calculations.
}
