% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Google.R
\name{Google}
\alias{Google}
\title{R6 Class containing specific attributes and methods for Google data}
\source{
\url{https://github.com/GoogleCloudPlatform/covid-19-open-data}
}
\description{
Google specific information for downloading, cleaning
and processing covid-19 region data for an example Country. The function
works the same as other national data sources, however, data from
Google supports three subregions (country, subregion and subregion2) which
can be accessed using the 'level' argument. There is also more data
available, such as hospitalisations data. The raw data comes as three
seperate data sets, "epidemiology" which is comprised of cases, tests and
deaths, "index", which holds information about countries linking the other
data sets, and "hospitalizations" which holds data about number of people
in hospital, ICU, etc.
}
\examples{
# nolint start
\dontrun{
# set up a data cache
start_using_memoise()

# get all countries
national <- Google$new(level = "1", get = TRUE)
national$return()

# show available regions with data at the second level of interest
google_level_2 <- Google$new(level = "2")
google_level_2$download()
google_level_2$clean()
google$available_regions()

# get all region data for the uk
google_level_2$filter("uk")
google_level_2$process()
google_level_2$return()

# get all regional data for the UK
uk <- Google$new(regions = "uk", level = "2", get = TRUE)
uk$return()

# get all subregional data for the UK
uk <- Google$new(regions = "uk", level = "3", get = TRUE)
uk$return()
}
# nolint end
}
\seealso{
Aggregated data sources
\code{\link{Covid19DataHub}},
\code{\link{JHU}}

National data sources
\code{\link{Covid19DataHub}},
\code{\link{ECDC}},
\code{\link{JHU}},
\code{\link{JRC}},
\code{\link{WHO}}

Subnational data sources
\code{\link{Belgium}},
\code{\link{Brazil}},
\code{\link{Canada}},
\code{\link{Colombia}},
\code{\link{Covid19DataHub}},
\code{\link{Cuba}},
\code{\link{France}},
\code{\link{Germany}},
\code{\link{India}},
\code{\link{Italy}},
\code{\link{JHU}},
\code{\link{Lithuania}},
\code{\link{Mexico}},
\code{\link{Netherlands}},
\code{\link{SouthAfrica}},
\code{\link{Switzerland}},
\code{\link{UK}},
\code{\link{USA}}
}
\concept{aggregations}
\concept{dataset}
\concept{national}
\concept{subnational}
\section{Super classes}{
\code{\link[covidregionaldata:DataClass]{covidregionaldata::DataClass}} -> \code{\link[covidregionaldata:CountryDataClass]{covidregionaldata::CountryDataClass}} -> \code{Google}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{origin}}{name of country to fetch data for}

\item{\code{supported_levels}}{A list of supported levels.}

\item{\code{supported_region_names}}{A list of region names in order of level.}

\item{\code{supported_region_codes}}{A list of region codes in order of level.}

\item{\code{common_data_urls}}{List of named links to raw data.}

\item{\code{source_data_cols}}{existing columns within the raw data}

\item{\code{source_text}}{Plain text description of the source of the data}

\item{\code{source_url}}{Website address for explanation/introduction of the
data}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-clean_common}{\code{Google$clean_common()}}
\item \href{#method-clean_level_1}{\code{Google$clean_level_1()}}
\item \href{#method-clean_level_2}{\code{Google$clean_level_2()}}
\item \href{#method-new}{\code{Google$new()}}
\item \href{#method-clone}{\code{Google$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="available_regions">}\href{../../covidregionaldata/html/DataClass.html#method-available_regions}{\code{covidregionaldata::DataClass$available_regions()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="clean">}\href{../../covidregionaldata/html/DataClass.html#method-clean}{\code{covidregionaldata::DataClass$clean()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="download">}\href{../../covidregionaldata/html/DataClass.html#method-download}{\code{covidregionaldata::DataClass$download()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="get">}\href{../../covidregionaldata/html/DataClass.html#method-get}{\code{covidregionaldata::DataClass$get()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="process">}\href{../../covidregionaldata/html/DataClass.html#method-process}{\code{covidregionaldata::DataClass$process()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="return">}\href{../../covidregionaldata/html/DataClass.html#method-return}{\code{covidregionaldata::DataClass$return()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="set_region_codes">}\href{../../covidregionaldata/html/DataClass.html#method-set_region_codes}{\code{covidregionaldata::DataClass$set_region_codes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="summary">}\href{../../covidregionaldata/html/DataClass.html#method-summary}{\code{covidregionaldata::DataClass$summary()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="test">}\href{../../covidregionaldata/html/DataClass.html#method-test}{\code{covidregionaldata::DataClass$test()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="CountryDataClass" data-id="filter">}\href{../../covidregionaldata/html/CountryDataClass.html#method-filter}{\code{covidregionaldata::CountryDataClass$filter()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clean_common"></a>}}
\if{latex}{\out{\hypertarget{method-clean_common}{}}}
\subsection{Method \code{clean_common()}}{
GoogleData specific subregion2 level data cleaning. This
takes all the raw data, puts into a single data frame, renames some
columns and checks types.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Google$clean_common()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clean_level_1"></a>}}
\if{latex}{\out{\hypertarget{method-clean_level_1}{}}}
\subsection{Method \code{clean_level_1()}}{
Google specific subregion level data cleaning. Takes the
data cleaned by \code{clean_common} and aggregates it to the country level
(level 1).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Google$clean_level_1()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clean_level_2"></a>}}
\if{latex}{\out{\hypertarget{method-clean_level_2}{}}}
\subsection{Method \code{clean_level_2()}}{
Google specific subregion2 level data cleaning. Takes the
data cleaned by \code{clean_common} and aggregates it to the subregion level
(level 2).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Google$clean_level_2()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
custom initialize for Google
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Google$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{arguments to be passed to \code{DataClass} and initialize Google}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Google$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
