% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_flow_data}
\alias{get_flow_data}
\title{Retrieve discharge data at specified gages}
\usage{
get_flow_data(gages_df, start_date, end_date)
}
\arguments{
\item{gages_df}{A dataframe that includes the column \code{site_no}, a
character vector with USGS gage IDs of stream gage sites to pull.}

\item{start_date}{Character string with the starting date, using "YYYY-MM-DD"
notation.}

\item{end_date}{Character string with the end date, using "YYYY-MM-DD"
notation.}
}
\value{
A dataframe with discharge data for each of the specified monitors.
  This is a dataframe that includes columns for the gage site number, date of
  each observation, and observed mean daily discharge (cubic feet per
  second).
}
\description{
Pulls all discharge data for the specified gage numbers and date range.
}
\examples{
\dontrun{
miami_gages <- get_gages("12086", start_date = "2000-01-01",
                            end_date = "2009-12-31")
miami_flow_data <- get_flow_data(gages_df = miami_gages,
                                 start_date = "2000-01-01",
                                 end_date = "2000-01-31")
# Example using piping
library(dplyr)
miami_flow_data <- get_gages("12086", start_date = "2000-01-01",
                                end_date = "2009-12-31") \%>\%
                   get_flow_data(start_date = "2000-01-01",
                                 end_date = "2000-01-31")
}
}
\seealso{
\code{\link[dataRetrieval]{readNWISdv}}
}
