% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{plot_pmf}
\alias{plot_pmf}
\title{Plot the empirical and model-based probability mass functions}
\usage{
plot_pmf(y, post.pred, error.bars = FALSE, alpha = 0.05)
}
\arguments{
\item{y}{\code{n x 1} vector of data}

\item{post.pred}{\code{nsave} draws from the posterior predictive distribution of \code{y}}

\item{error.bars}{logical; if TRUE, include errors bars on the model-based PMF}

\item{alpha}{confidence level for the credible intervals}
}
\value{
A plot of the empirical PMF of y along with a PMF estimate from the model posterior
predictive distribution
}
\description{
Plot the empirical probability mass function, i.e., the proportion of
data values \code{y} that equal \code{j} for each \code{j=0,1,...},
together with the model-based estimate of the probability mass function
based on the posterior predictive distribution.
}
