% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wap.R
\name{predict.wap}
\alias{predict.wap}
\title{Predict method for Weighted All-Pairs}
\usage{
\method{predict}{wap}(object, newdata, type = "class",
  criterion = "most-wins", ...)
}
\arguments{
\item{object}{An object of class `wap` as output by function `weighted.all.pairs`.}

\item{newdata}{New data on which to make predictions.}

\item{type}{One of "class" (will output the class with minimum expected cost) or "score"
(will output the predicted score for each class, i.e. more is better).}

\item{criterion}{One of "goodness" (will use the sum of probabilities output by each classifier) or "most-wins"
(will use the predicted class by each classifier).}

\item{...}{Additional arguments to pass to the predict method of the base classifier.}
}
\value{
When passing `type = "class"`, a vector with class numbers or names (if the cost matrix had them).
When passing `type = "score"`, will output a `matrix` with the same number of columns as `C` (passed to
the `weighted.all.pairs` function) and the predicted score for each observation and class.
}
\description{
Predicts either the class with expected minimum cost or scores (more is better) for new data.
}
