% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{ssgsea}
\alias{ssgsea}
\title{ssGSEA}
\usage{
ssgsea(inmat, groups, scale = TRUE, minsize = 10)
}
\arguments{
\item{inmat}{A numeric matrix, with rownames/rows as genes or features, and
colnames/columns as sample names}

\item{groups}{a named list. Names are names of the groups (e.g. pathways) and
elements are character vectors indicating gene or feature names (that should
match, at least partially, with the rownames of inmat)}

\item{scale}{Boolean. Wheter the matrix should be row-scaled.}

\item{minsize}{Numeric. Include only groups with at least this many elements
Default is 10}
}
\value{
A matrix of Normalized Enrichment Scores (NES), which can be converted to
p-values using the function _corto::z2p_
}
\description{
This function performs single sample GSEA
}
\examples{
# A random matrix
set.seed(1)
inmat<-matrix(rnorm(200*50),nrow=200,ncol=50)
rownames(inmat)<-paste0("gene",1:nrow(inmat))
# A random list of groups
groups<-list()
for(i in 1:10){
    somegenes<-sample(rownames(inmat),30)
    groups[[paste0("pathway_",i)]]<-somegenes
}
# Run ssGSEA
nesmat<-ssgsea(inmat,groups)

}
