% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrRect.R
\name{corrRect}
\alias{corrRect}
\title{Draw rectangle(s) on the correlation matrix graph.}
\usage{
corrRect(clus, col = "black", lwd = 2)
}
\arguments{
\item{clus}{Vector, the number of each cluster's members.}

\item{col}{Color of rectangles.}

\item{lwd}{Line width of rectangles.}
}
\description{
Draw rectangle(s) around the chart of corrrlation matrix.
}
\details{
\code{corrRect} needs the number(parameter \code{clus}) of each cluster's
members, while \code{corrRect.hclust}  can get the members in each cluster
based on hierarchical clustering (\code{\link{hclust}}).
}
\examples{
data(mtcars)
M <- cor(mtcars)
corrplot(M, method = "circle", order = "FPC")
corrRect(c(5,6))

(order.hc <- corrMatOrder(M, order = "hclust"))
(order.hc2 <- corrMatOrder(M, order = "hclust", hclust.method = "ward.D"))
M.hc  <- M[order.hc, order.hc]
M.hc2 <- M[order.hc2, order.hc2]

par(ask = TRUE)

# same as: corrplot(M, order = "hclust", addrect = 2)
corrplot(M.hc)
corrRect.hclust(corr = M.hc, k = 2)

# same as: corrplot(M, order = "hclust", addrect = 3)
corrplot(M.hc)
corrRect.hclust(corr = M.hc, k = 3)

# same as: corrplot(M, order = "hclust", hclust.method = "ward.D", addrect = 2)
corrplot(M.hc2)
corrRect.hclust(M.hc2, k = 2, method = "ward.D")

# same as: corrplot(M, order = "hclust", hclust.method = "ward.D", addrect = 3)
corrplot(M.hc2)
corrRect.hclust(M.hc2, k = 3, method = "ward.D")

# same as: corrplot(M, order = "hclust", hclust.method = "ward.D", addrect = 4)
corrplot(M.hc2)
corrRect.hclust(M.hc2, k = 4, method = "ward.D")
}
\author{
Taiyun Wei
}
\keyword{hplot}
