% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahalanobis.R
\name{distance_mahalanobis}
\alias{distance_mahalanobis}
\title{Mahalanobis distance and confidence interval (CI)}
\usage{
distance_mahalanobis(data, ci = 0.95, iterations = 1000, robust = TRUE, ...)
}
\arguments{
\item{data}{A data frame.}

\item{ci}{Confidence/Credible Interval level. If \code{"default"}, then it is set to 0.95 (95\% CI).}

\item{iterations}{The number of draws to simulate/bootstrap (when \code{robust} is \code{TRUE}).}

\item{robust}{If \code{TRUE}, will run a bootstrapped version of the function with i iterations.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
Description of the Mahalanobis distance.
}
\description{
The Mahalanobis distance (in squared units) measures the distance in multivariate space taking into account the covariance structure of the data. Because a few extreme outliers can skew the covariance estimate, the bootstrapped version is considered as more robust.
}
\examples{
library(correlation)

distance_mahalanobis(iris[, 1:4])
distance_mahalanobis(iris[, 1:4], robust = FALSE)
}
\references{
\itemize{
  \item Schwarzkopf, D. S., De Haas, B., & Rees, G. (2012). Better ways to improve standards in brain-behavior correlation analysis. Frontiers in human neuroscience, 6, 200.
}
}
