% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corregp.r
\name{print.anova.corregp}
\alias{print.anova.corregp}
\title{Printing the ANOVA Table of Correspondence Regression}
\usage{
\method{print}{anova.corregp}(x, ...)
}
\arguments{
\item{x}{The output of a call to \code{anova} on a "corregp" object (i.e. an object of class "anova.corregp").}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The output of a call to \code{anova} on a "corregp" object.
}
\description{
Method to print the output of \code{\link{anova.corregp}}.
}
\examples{
\donttest{
data(HairEye)
haireye.crg <- corregp(Eye ~ Hair * Sex, data = HairEye, b = 3000)
anova(haireye.crg, nf = 2)
}
}
\seealso{
\code{\link{anova.corregp}}.
}
