% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semnet_plotting.r
\name{plot_semnet}
\alias{plot_semnet}
\title{Visualize a semnet network}
\usage{
plot_semnet(
  g,
  weight_attr = "weight",
  min_weight = NA,
  delete_isolates = F,
  vertexsize_attr = "freq",
  vertexsize_coef = 1,
  vertexcolor_attr = NA,
  edgewidth_coef = 1,
  max_backbone_alpha = NA,
  labelsize_coef = 1,
  labelspace_coef = 1.1,
  reduce_labeloverlap = F,
  redo_layout = F,
  return_graph = T,
  vertex.label.dist = 0.25,
  layout_fun = igraph::layout_with_fr,
  ...
)
}
\arguments{
\item{g}{A network in the igraph format. Specifically designed for the output of coOccurenceNetwork() and windowedCoOccurenceNetwork()}

\item{weight_attr}{The name of the weight attribute. Default is 'weight'}

\item{min_weight}{The minimum weight. All edges with a lower weight are dropped}

\item{delete_isolates}{If TRUE, isolate vertices (also after applying min_weight) are dropped}

\item{vertexsize_attr}{a character string indicating a vertex attribute that represents size. Default is 'freq', which is created in the coOccurenceNetwork functions to indicate the number of times a token occured.}

\item{vertexsize_coef}{a coefficient for changing the vertex size.}

\item{vertexcolor_attr}{a character string indicating a vertex attribute that represents color. The attribute can also be a numeric value (e.g., a cluster membership) in which case colors are assigned to numbers. If no (valid) color attribute is given, vertex color are based on undirected fastgreedy.community() clustering.}

\item{edgewidth_coef}{a coefficient for changing the edge width}

\item{max_backbone_alpha}{If g has an edge attribute named alpha (added if backbone extraction is used), this specifies the maximum alpha value.}

\item{labelsize_coef}{a coefficient for increasing or decreasing the size of the vertexlabel.}

\item{labelspace_coef}{a coefficient that roughly determines the minimal distance between vertex labels, based on the size of labels. Only used if reduce_labeloverlap is TRUE.}

\item{reduce_labeloverlap}{if TRUE, an algorithm is used to reduce overlap as best as possible.}

\item{redo_layout}{If TRUE, a new layout will be calculated using layout_with_fr(). If g does not have a layout attribute (g$layout), a new layout is automatically calculated.}

\item{return_graph}{if TRUE, plot_semnet() also returns the graph object with the attributes and layout as shown in the plot.}

\item{vertex.label.dist}{The distance of the label to the center of the vertex}

\item{layout_fun}{The igraph layout function that is used.}

\item{...}{additional arguments are passed on to plot.igraph()}
}
\value{
Plots a network, and returns the network object if return_graph is TRUE.
}
\description{
plot_semnet is a wrapper for the plot.igraph() function optimized for plotting a semantic network of the "semnet" class.
}
\details{
Before plotting the network, the set_network_attributes() function is used to set pretty defaults for plotting. Optionally, reduce_labeloverlap can be used to prevent labeloverlap (as much as possible).
}
\examples{
tc = create_tcorpus(sotu_texts, doc_column = 'id')
tc$preprocess('token','feature', remove_stopwords = TRUE, use_stemming = TRUE, min_docfreq=10)
\donttest{
g = semnet_window(tc, 'feature', window.size = 10)
g = backbone_filter(g, max_vertices = 100)
plot_semnet(g)
}
}
