% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearProductionGame.R
\name{linearProductionGame}
\alias{linearProductionGame}
\title{Cooperative linear production games}
\usage{
linearProductionGame(c, A, B, plot = FALSE, show.data = FALSE)
}
\arguments{
\item{c}{vector containing the benefits of the products.}

\item{A}{production matrix.}

\item{B}{matrix containing the amount of resources of the several players 
where each row is one player.}

\item{plot}{logical value indicating if the function displays graphical 
solution (\code{TRUE}) or not (\code{FALSE}). Note that this option only makes
sense when we have a two-dimension problem.}

\item{show.data}{logical value indicating if the function displays the 
console output (\code{TRUE}) or not (\code{FALSE}). By default the 
value is \code{TRUE}.}
}
\value{
\code{linearProductionGame} returns a list with the solutions of 
the associated problem of each coalition and the objective value for coalition N.
}
\description{
Given a linear production problem, the
\code{linearProductionGame} function solves the problem by making use of \code{lpSolveAPI}
where each agent provides his own resources.
}
\examples{
# Vector of benefits
c <- c(68,52)
# Production matrix
A <- matrix(c(4,5,6,2),ncol=2, byrow = TRUE)
# Matrix of resources. Each column is the vector of resources of each player
B <- matrix(c(4, 6, 60, 33, 39, 0),ncol = 3, byrow = TRUE)
# Solution of the associated linear production game
linearProductionGame(c, A, B, show.data = TRUE)

 # ------------------------------------------------------------------------
 # Optimal solution of the problem for each coalition: 
 # ------------------------------------------------------------------------
 # 
 # S={1}      1.00  0.00
 # S={2}      1.50  0.00
 # S={3}      0.00  0.00
 # S={1,2}    2.50  0.00
 # S={1,3}    1.68 11.45
 # S={2,3}    2.86 10.91
 # S={1,2,3} 10.00  6.00
 # 
 # ------------------------------------------------------------------------
 #   Cooperative production game: 
 # ------------------------------------------------------------------------
 #                S={0} S={1} S={2} S={3} S={1,2} S={1,3} S={2,3} S={1,2,3}
 # Associated game    0    68   102     0     170     710     762       992
 # ------------------------------------------------------------------------

  
}
\author{
D. Prieto
}
