% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convoSPAT_paramEst.R
\name{make_global_loglik3}
\alias{make_global_loglik3}
\title{Constructor functions for global parameter estimation.}
\usage{
make_global_loglik3(data, Xmat, Corr, obs.variance, nugg2.var)
}
\arguments{
\item{data}{A vector or matrix of data to use in the likelihood
calculation.}

\item{Xmat}{The design matrix for the mean model.}

\item{Corr}{The correlation matrix matrix.}

\item{obs.variance}{A vector containing the spatially-varying variance
corresponding to each data location.}

\item{nugg2.var}{Fixed values for the covariance of the second nugget term.}
}
\value{
This function returns another function for use in \code{optim}.
}
\description{
This function generates another function to be used within \code{optim} to
obtain maximum likelihood estimates of
global variance parameter tausq with a fixed correlation
matrix (smoothness is fixed). The process variance is taken
to be spatially-varing.
}
\examples{
\dontrun{
make_global_loglik3( data, Xmat, Corr, obs.variance, nugg2.var )
}

}
